/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto.raes;

import de.schlichtherle.truezip.crypto.SICSeekableBlockCipher;
import de.schlichtherle.truezip.crypto.SeekableBlockCipher;
import de.schlichtherle.truezip.crypto.SuspensionPenalty;
import de.schlichtherle.truezip.crypto.raes.RaesAuthenticationException;
import de.schlichtherle.truezip.crypto.raes.RaesException;
import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.Type0RaesParameters;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.util.ArrayHelper;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.EOFException;
import java.io.IOException;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

@NotThreadSafe
final class Type0RaesReadOnlyFile
extends RaesReadOnlyFile {
    private final Type0RaesParameters.KeyStrength keyStrength;
    private final KeyParameter sha256MacParam;
    private final byte[] footer;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    Type0RaesReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile rof, Type0RaesParameters param) throws IOException {
        super(rof);
        KeyParameter sha256MacParam;
        ParametersWithIV aesCtrParam;
        byte[] buf;
        Type0RaesParameters.KeyStrength keyStrength;
        assert (null != param);
        rof.seek(0L);
        long fileLength = rof.length();
        byte[] header = new byte[8];
        rof.readFully(header);
        short keyStrengthOrdinal = Type0RaesReadOnlyFile.readUByte(header, 5);
        try {
            keyStrength = Type0RaesParameters.KeyStrength.values()[keyStrengthOrdinal];
            assert (keyStrength.ordinal() == keyStrengthOrdinal);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RaesException("Unknown index for cipher key strength: " + keyStrengthOrdinal);
        }
        int keyStrengthBytes = keyStrength.getBytes();
        int keyStrengthBits = keyStrength.getBits();
        this.keyStrength = keyStrength;
        int iCount = Type0RaesReadOnlyFile.readUShort(header, 6);
        if (1024 > iCount) {
            throw new RaesException("Iteration count must be 1024 or greater, but is " + iCount + "!");
        }
        byte[] salt = new byte[keyStrengthBytes];
        rof.readFully(salt);
        HMac klac = new HMac((Digest)new SHA256Digest());
        this.footer = new byte[klac.getMacSize()];
        long start = header.length + salt.length;
        long end = fileLength - (long)this.footer.length;
        long length = end - start;
        if (length < 0L) {
            throw new RaesException("False positive Type 0 RAES file is too short!", new EOFException());
        }
        rof.seek(end);
        rof.readFully(this.footer);
        if (-1 != rof.read()) {
            throw new RaesException("Expected end of file after data envelope trailer!");
        }
        PKCS12ParametersGenerator gen = new PKCS12ParametersGenerator((Digest)new SHA256Digest());
        long lastTry = 0L;
        do {
            char[] passwd = param.getReadPassword(0L != lastTry);
            assert (null != passwd);
            byte[] pass = PBEParametersGenerator.PKCS12PasswordToBytes((char[])passwd);
            int i = passwd.length;
            while (--i >= 0) {
                passwd[i] = '\u0000';
            }
            gen.init(pass, salt, iCount);
            aesCtrParam = (ParametersWithIV)gen.generateDerivedParameters(keyStrengthBits, 128);
            sha256MacParam = (KeyParameter)gen.generateDerivedMacParameters(keyStrengthBits);
            this.paranoidWipe(pass);
            lastTry = SuspensionPenalty.enforce((long)lastTry);
            klac.init((CipherParameters)sha256MacParam);
            byte[] cipherKey = ((KeyParameter)aesCtrParam.getParameters()).getKey();
            klac.update(cipherKey, 0, cipherKey.length);
            buf = new byte[klac.getMacSize()];
            RaesOutputStream.klac((Mac)klac, length, buf);
        } while (!ArrayHelper.equals((byte[])this.footer, (int)0, (byte[])buf, (int)0, (int)(buf.length / 2)));
        this.sha256MacParam = sha256MacParam;
        SICSeekableBlockCipher cipher = new SICSeekableBlockCipher((BlockCipher)new AESFastEngine());
        cipher.init(false, (CipherParameters)aesCtrParam);
        this.init((SeekableBlockCipher)cipher, start, length);
        param.setKeyStrength(keyStrength);
    }

    private void paranoidWipe(byte[] pwd) {
        int i = pwd.length;
        while (--i >= 0) {
            pwd[i] = 0;
        }
    }

    @Override
    public Type0RaesParameters.KeyStrength getKeyStrength() {
        return this.keyStrength;
    }

    @Override
    public void authenticate() throws IOException {
        HMac mac = new HMac((Digest)new SHA256Digest());
        mac.init((CipherParameters)this.sha256MacParam);
        byte[] buf = this.computeMac((Mac)mac);
        assert (buf.length == mac.getMacSize());
        if (!ArrayHelper.equals((byte[])buf, (int)0, (byte[])this.footer, (int)(this.footer.length / 2), (int)(this.footer.length / 2))) {
            throw new RaesAuthenticationException();
        }
    }
}

