/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip.raes;

import de.schlichtherle.truezip.crypto.raes.RaesOutputStream;
import de.schlichtherle.truezip.crypto.raes.RaesParameters;
import de.schlichtherle.truezip.crypto.raes.RaesReadOnlyFile;
import de.schlichtherle.truezip.crypto.raes.param.AesCipherParameters;
import de.schlichtherle.truezip.crypto.raes.param.KeyManagerRaesParameters;
import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.zip.JarDriver;
import de.schlichtherle.truezip.fs.archive.zip.OptionOutputSocket;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriverEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.fs.archive.zip.raes.ZipRaesKeyController;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyManagerProvider;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.LazyOutputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class ZipRaesDriver
extends JarDriver {
    private final KeyManagerProvider keyManagerProvider;

    public ZipRaesDriver(IOPoolProvider ioPoolProvider, KeyManagerProvider keyManagerProvider) {
        super(ioPoolProvider);
        this.keyManagerProvider = keyManagerProvider;
        if (null == this.keyManagerProvider) {
            throw new NullPointerException();
        }
    }

    public final boolean getPreambled() {
        return true;
    }

    protected final KeyManagerProvider getKeyManagerProvider() {
        return this.keyManagerProvider;
    }

    protected RaesParameters raesParameters(FsModel model) {
        return new KeyManagerRaesParameters((KeyManager<AesCipherParameters>)this.getKeyManagerProvider().get(AesCipherParameters.class), this.mountPointUri(model));
    }

    protected abstract long getAuthenticationTrigger();

    protected final boolean check(ZipInputShop input, ZipDriverEntry entry) {
        return input.length() > this.getAuthenticationTrigger();
    }

    public <M extends FsModel> FsController<M> decorate(FsController<M> controller) {
        return new ZipRaesKeyController<M>(controller, this);
    }

    public ZipDriverEntry newEntry(String path, Entry.Type type, @CheckForNull Entry template, BitField<FsOutputOption> mknod) throws CharConversionException {
        ZipDriverEntry entry = super.newEntry(path, type, template, mknod.set((Enum)FsOutputOption.COMPRESS));
        entry.clearEncryption();
        return entry;
    }

    public final InputShop<ZipDriverEntry> newInputShop(FsModel model, InputSocket<?> input) throws IOException {
        if (null == model) {
            throw new NullPointerException();
        }
        ReadOnlyFile rof = input.newReadOnlyFile();
        try {
            RaesReadOnlyFile rrof = RaesReadOnlyFile.getInstance(rof, this.raesParameters(model));
            if (rrof.length() <= this.getAuthenticationTrigger()) {
                rrof.authenticate();
            }
            return this.newInputShop(model, (ReadOnlyFile)rrof);
        }
        catch (IOException ex) {
            rof.close();
            throw ex;
        }
    }

    public final OptionOutputSocket getOutputSocket(FsController<?> controller, FsEntryName name, BitField<FsOutputOption> options, @CheckForNull Entry template) {
        options = options.set((Enum)FsOutputOption.STORE);
        options = options.clear((Enum)FsOutputOption.GROW);
        return new OptionOutputSocket(controller.getOutputSocket(name, options, template), options);
    }

    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    protected OutputShop<ZipDriverEntry> newOutputShop(FsModel model, OptionOutputSocket output, ZipInputShop source) throws IOException {
        if (null == model) {
            throw new NullPointerException();
        }
        OutputStream out = new LazyOutputSocket((OutputSocket)output).newOutputStream();
        try {
            RaesOutputStream ros = RaesOutputStream.getInstance(out, this.raesParameters(model));
            return this.newOutputShop(model, (OutputStream)((Object)ros), source);
        }
        catch (IOException ex) {
            out.close();
            throw ex;
        }
    }
}

