/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class OctetCharsetTestCase {
    private Charset charset;

    @Before
    public void setUp() throws Exception {
        this.charset = this.newCharset();
    }

    protected abstract Charset newCharset();

    @Test
    public void testRoundTrip() throws CharacterCodingException {
        CharsetDecoder dec = this.charset.newDecoder();
        CharsetEncoder enc = this.charset.newEncoder();
        byte[] b1 = new byte[256];
        for (int i = 0; i < b1.length; ++i) {
            b1[i] = (byte)i;
        }
        ByteBuffer bb1 = ByteBuffer.wrap(b1);
        CharBuffer cb = dec.decode(bb1);
        ByteBuffer bb2 = enc.encode(cb);
        byte[] b2 = bb2.array();
        Assert.assertTrue((boolean)Arrays.equals(b1, b2));
    }
}

