/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.DateTimeConverter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class DateTimeConverterTestCase {
    private static final long MIN_DOS_TIME = 0x210000L;
    private DateTimeConverter instance;
    private Calendar cal;

    @Before
    public void setUp() {
        this.instance = this.getInstance();
        this.cal = new GregorianCalendar(this.instance.newTimeZone());
        this.cal.set(14, 0);
    }

    protected abstract DateTimeConverter getInstance();

    @Test
    public final void testToJavaTime() {
        block12: {
            try {
                this.instance.toJavaTime(-1L);
                Assert.fail((String)"Expected RuntimeException");
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            try {
                this.instance.toJavaTime(0L);
                Assert.fail((String)"Expected RuntimeException");
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            try {
                this.instance.toJavaTime(0x20FFFFL);
                Assert.fail((String)"Expected RuntimeException");
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
            boolean ea = false;
            if (!$assertionsDisabled) {
                ea = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            try {
                this.instance.toJavaTime(0xFFFFFFFFL);
                Assert.assertFalse((String)"Expected RuntimeException if assertions are enabled", (boolean)ea);
            }
            catch (RuntimeException ex) {
                if (ea) break block12;
                AssertionFailedError afe = new AssertionFailedError("Did not expect a RuntimeException if assertions are disabled");
                afe.initCause(ex);
                throw afe;
            }
        }
        try {
            this.instance.toJavaTime(0x100000000L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.cal.set(1980, 0, 1, 0, 0, 0);
        Assert.assertEquals((long)this.cal.getTimeInMillis(), (long)this.instance.toJavaTime(0x210000L));
    }

    @Test
    public final void testToDosTime() {
        try {
            this.instance.toDosTime(-1L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)0x210000L, (long)this.instance.toDosTime(0L));
        this.cal.set(1980, 0, 1, 0, 0, 0);
        Assert.assertEquals((long)0x210000L, (long)this.instance.toDosTime(this.cal.getTimeInMillis()));
    }

    @Test
    public final void testCreateTimeZone() {
        TimeZone tz1 = this.instance.newTimeZone();
        Assert.assertNotNull((Object)tz1);
        TimeZone tz2 = this.instance.newTimeZone();
        Assert.assertNotNull((Object)tz1);
        Assert.assertNotSame((Object)tz1, (Object)tz2);
        Assert.assertTrue((boolean)tz1.hasSameRules(tz2));
    }

    @Test
    public final void testRoundUp() {
        this.instance.roundUp(System.currentTimeMillis());
    }
}

