/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import de.schlichtherle.truezip.zip.ZipTestCase;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class PlainZipTest
extends ZipTestCase {
    private static final Random rnd = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testAppending() throws IOException {
        byte[] data1 = this.getData();
        byte[] data2 = new byte[data1.length];
        rnd.nextBytes(data2);
        this.append(0, 20, data1);
        this.append(10, 20, data2);
        File zip = this.getZip();
        ZipFile zipIn = this.newZipFile(zip);
        Assert.assertEquals((long)30L, (long)zipIn.size());
        try {
            byte[] buf = new byte[data1.length];
            for (int i = 0; i < 30; ++i) {
                String name = i + ".txt";
                ZipEntry entry = zipIn.getEntry(name);
                Assert.assertEquals((long)data1.length, (long)entry.getSize());
                InputStream in = zipIn.getInputStream(name);
                try {
                    int read;
                    int off = 0;
                    do {
                        if ((read = in.read(buf, off, buf.length - off)) < 0) {
                            throw new EOFException();
                        }
                        Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                    } while ((off += read) < buf.length);
                    Assert.assertEquals((long)-1L, (long)in.read());
                    Assert.assertTrue((boolean)Arrays.equals(i < 10 ? data1 : data2, buf));
                    continue;
                }
                finally {
                    in.close();
                }
            }
        }
        finally {
            zipIn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(int off, int len, byte[] data) throws IOException {
        ZipOutputStream out;
        File zip = this.getZip();
        if (zip.exists()) {
            ZipFile in = this.newZipFile(zip);
            in.close();
            out = this.newZipOutputStream((OutputStream)new FileOutputStream(zip, true), in);
        } else {
            out = this.newZipOutputStream(new FileOutputStream(zip));
        }
        try {
            for (int i = 0; i < len; ++i) {
                String name = off + i + ".txt";
                out.putNextEntry(new ZipEntry(name));
                out.write(data);
            }
        }
        finally {
            out.close();
        }
    }
}

