/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.DateTimeConverter;
import de.schlichtherle.truezip.zip.ZipConstants;
import de.schlichtherle.truezip.zip.ZipEntry;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ZipEntryTest {
    private ZipEntry entry;

    @Before
    public void setUp() {
        this.entry = new ZipEntry("test");
    }

    @Test
    public void testClone() {
        ZipEntry clone = this.entry.clone();
        Assert.assertNotSame((Object)clone, (Object)this.entry);
    }

    @Test
    public void testPlatform() {
        try {
            this.entry.setPlatform((short)-2);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.entry.setPlatform((short)256);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getPlatform());
        this.entry.setPlatform((short)0);
        Assert.assertEquals((long)0L, (long)this.entry.getPlatform());
        this.entry.setPlatform((short)0);
        Assert.assertEquals((long)0L, (long)this.entry.getPlatform());
        this.entry.setPlatform((short)3);
        Assert.assertEquals((long)3L, (long)this.entry.getPlatform());
        this.entry.setPlatform((short)255);
        Assert.assertEquals((long)255L, (long)this.entry.getPlatform());
        this.entry.setPlatform((short)-1);
        Assert.assertEquals((long)-1L, (long)this.entry.getPlatform());
    }

    @Test
    public void testGeneral() {
        try {
            this.entry.setGeneral(-2);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.entry.setGeneral(65536);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getGeneral());
        this.entry.setGeneral(0);
        Assert.assertEquals((long)0L, (long)this.entry.getGeneral());
        this.entry.setGeneral(8);
        Assert.assertEquals((long)8L, (long)this.entry.getGeneral());
        this.entry.setGeneral(2048);
        Assert.assertEquals((long)2048L, (long)this.entry.getGeneral());
        this.entry.setGeneral(65535);
        Assert.assertEquals((long)65535L, (long)this.entry.getGeneral());
        this.entry.setGeneral(-1);
        Assert.assertEquals((long)-1L, (long)this.entry.getGeneral());
    }

    @Test
    public void testGeneralBit() {
        for (int i = -1; i < 17; ++i) {
            try {
                this.entry.getGeneralBit(i);
                Assert.fail((String)"Expected IllegalStateException");
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            this.entry.setGeneralBit(-1, false);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        for (int i = 0; i < 16; ++i) {
            this.entry.setGeneralBit(i, false);
            Assert.assertFalse((boolean)this.entry.getGeneralBit(i));
            this.entry.setGeneralBit(i, true);
            Assert.assertTrue((boolean)this.entry.getGeneralBit(i));
        }
        try {
            this.entry.setGeneralBit(16, false);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        this.entry.setGeneral(-1);
        try {
            this.entry.getGeneralBit(0);
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMethod() {
        try {
            this.entry.setMethod(-2);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.entry.setMethod(65535);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.entry.setMethod(65536);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getMethod());
        this.entry.setMethod(0);
        Assert.assertEquals((long)0L, (long)this.entry.getMethod());
        this.entry.setMethod(8);
        Assert.assertEquals((long)8L, (long)this.entry.getMethod());
        this.entry.setMethod(-1);
        Assert.assertEquals((long)-1L, (long)this.entry.getMethod());
    }

    @Test
    public void testRoundTripTimeConversion() {
        long dosTime = 0x210000L;
        Assert.assertEquals((long)dosTime, (long)DateTimeConverter.JAR.toDosTime(DateTimeConverter.JAR.toJavaTime(dosTime)));
        dosTime = DateTimeConverter.JAR.toDosTime(System.currentTimeMillis());
        Assert.assertEquals((long)dosTime, (long)DateTimeConverter.JAR.toDosTime(DateTimeConverter.JAR.toJavaTime(dosTime)));
    }

    @Test
    public void testDosTime() {
        try {
            this.entry.setDosTime(-2L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.entry.setDosTime(0L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.entry.setDosTime(0x100000000L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getDosTime());
        this.entry.setDosTime(0x210000L);
        Assert.assertEquals((long)0x210000L, (long)this.entry.getDosTime());
        this.entry.setDosTime(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getDosTime());
    }

    @Test
    public void testTime() {
        try {
            this.entry.setTime(-2L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getTime());
        this.entry.setTime(0L);
        long time = this.entry.getTime();
        Assert.assertEquals((long)time, (long)DateTimeConverter.JAR.toJavaTime(0x210000L));
        this.entry.setTime(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getTime());
    }

    @Test
    public void testCrc() {
        try {
            this.entry.setCrc(-2L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.entry.setCrc(0x100000000L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getCrc());
        this.entry.setCrc(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getCrc());
        this.entry.setCrc(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getCrc());
        this.entry.setCrc(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getCrc());
    }

    @Test
    public void testCompressedSize32() {
        try {
            this.entry.setCompressedSize32(-2L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.entry.setCompressedSize32(0x100000000L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getCompressedSize32());
        this.entry.setCompressedSize32(0L);
        Assert.assertEquals((long)(ZipConstants.FORCE_ZIP64_EXT ? 0xFFFFFFFFL : 0L), (long)this.entry.getCompressedSize32());
        this.entry.setCompressedSize32(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getCompressedSize32());
        this.entry.setCompressedSize32(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getCompressedSize32());
    }

    @Test
    public void testCompressedSize() {
        try {
            this.entry.setCompressedSize(-2L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getCompressedSize());
        this.entry.setCompressedSize(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getCompressedSize());
        this.entry.setCompressedSize(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getCompressedSize());
        this.entry.setCompressedSize(0x100000000L);
        Assert.assertEquals((long)0x100000000L, (long)this.entry.getCompressedSize());
        this.entry.setCompressedSize(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getCompressedSize());
    }

    @Test
    public void testSize32() {
        try {
            this.entry.setSize32(-2L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.entry.setSize32(0x100000000L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getSize32());
        this.entry.setSize32(0L);
        Assert.assertEquals((long)(ZipConstants.FORCE_ZIP64_EXT ? 0xFFFFFFFFL : 0L), (long)this.entry.getSize32());
        this.entry.setSize32(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getSize32());
        this.entry.setSize32(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getSize32());
    }

    @Test
    public void testSize() {
        try {
            this.entry.setSize(-2L);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getSize());
        this.entry.setSize(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getSize());
        this.entry.setSize(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getSize());
        this.entry.setSize(0x100000000L);
        Assert.assertEquals((long)0x100000000L, (long)this.entry.getSize());
        this.entry.setSize(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getSize());
    }

    @Test
    public void testOffset32() {
        try {
            this.entry.setOffset32(-2L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException ex) {
            // empty catch block
        }
        try {
            this.entry.setOffset32(0x100000000L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getOffset32());
        this.entry.setOffset32(0L);
        Assert.assertEquals((long)(ZipConstants.FORCE_ZIP64_EXT ? 0xFFFFFFFFL : 0L), (long)this.entry.getOffset32());
        this.entry.setOffset32(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getOffset32());
        this.entry.setOffset32(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getOffset32());
    }

    @Test
    public void testOffset() {
        try {
            this.entry.setOffset(-2L);
            Assert.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)this.entry.getOffset());
        this.entry.setOffset(0L);
        Assert.assertEquals((long)0L, (long)this.entry.getOffset());
        this.entry.setOffset(0xFFFFFFFFL);
        Assert.assertEquals((long)0xFFFFFFFFL, (long)this.entry.getOffset());
        this.entry.setOffset(0x100000000L);
        Assert.assertEquals((long)0x100000000L, (long)this.entry.getOffset());
        this.entry.setOffset(-1L);
        Assert.assertEquals((long)-1L, (long)this.entry.getOffset());
    }

    @Test
    public void testExtra() {
        Assert.assertEquals((long)0L, (long)this.entry.getExtra().length);
        byte[] set = new byte[]{0, 0, 0, 0, 1, 0, 24, 0, 33, 67, 101, -121, -87, -53, -19, 15, 34, 67, 101, -121, -87, -53, -19, 15, 35, 67, 101, -121, -87, -53, -19, 15, -2, -54, 0, 0};
        this.entry.setSize32(0xFFFFFFFFL);
        this.entry.setCompressedSize32(0xFFFFFFFFL);
        this.entry.setOffset32(0xFFFFFFFFL);
        this.entry.setExtra(set);
        Assert.assertEquals((long)1147797409030816545L, (long)this.entry.getSize());
        Assert.assertEquals((long)1147797409030816546L, (long)this.entry.getCompressedSize());
        Assert.assertEquals((long)1147797409030816547L, (long)this.entry.getOffset());
        set[0] = -1;
        byte[] got1 = this.entry.getExtra();
        Assert.assertNotNull((Object)got1);
        Assert.assertNotSame((Object)set, (Object)got1);
        byte[] got2 = this.entry.getExtra();
        Assert.assertNotNull((Object)got2);
        Assert.assertNotSame((Object)set, (Object)got2);
        Assert.assertNotSame((Object)got1, (Object)got2);
        set[0] = 0;
        Assert.assertTrue((boolean)Arrays.equals(set, got1));
        Assert.assertTrue((boolean)Arrays.equals(set, got2));
    }
}

