/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.archive.FsCharsetArchiveDriver;
import de.schlichtherle.truezip.fs.archive.FsMultiplexedArchiveOutputShop;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.fs.archive.zip.ZipOutputShop;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.InputShop;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.zip.ZipEntryFactory;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public class ZipDriver
extends FsCharsetArchiveDriver<ZipArchiveEntry>
implements ZipEntryFactory<ZipArchiveEntry> {
    private static final Charset ZIP_CHARSET = Charset.forName("IBM437");
    private final IOPool<?> pool;

    public ZipDriver(IOPoolProvider service) {
        this(service, ZIP_CHARSET);
    }

    protected ZipDriver(IOPoolProvider provider, Charset charset) {
        super(charset);
        this.pool = provider.get();
    }

    public final IOPool<?> getPool() {
        return this.pool;
    }

    public boolean getPreambled() {
        return false;
    }

    public boolean getPostambled() {
        return false;
    }

    public int getMethod() {
        return 8;
    }

    public int getLevel() {
        return 9;
    }

    public ZipArchiveEntry newEntry(String name, Entry.Type type, Entry template) throws CharConversionException {
        ZipArchiveEntry entry;
        this.assertEncodable(name);
        name = ZipDriver.toZipOrTarEntryName((String)name, (Entry.Type)type);
        if (template instanceof ZipArchiveEntry) {
            entry = this.newEntry(name, (ZipArchiveEntry)template);
        } else {
            entry = this.newEntry(name);
            if (null != template) {
                entry.setTime(template.getTime(Entry.Access.WRITE));
                entry.setSize(template.getSize(Entry.Size.DATA));
            }
        }
        return entry;
    }

    @Override
    public ZipArchiveEntry newEntry(String name) {
        return new ZipArchiveEntry(name);
    }

    public ZipArchiveEntry newEntry(String name, ZipArchiveEntry template) {
        return new ZipArchiveEntry(name, template);
    }

    public ZipInputShop newInputShop(FsConcurrentModel model, InputSocket<?> input) throws IOException {
        ReadOnlyFile rof = input.newReadOnlyFile();
        try {
            return this.newZipInputShop(model, rof);
        }
        catch (IOException ex) {
            rof.close();
            throw ex;
        }
    }

    protected ZipInputShop newZipInputShop(FsConcurrentModel model, ReadOnlyFile rof) throws IOException {
        return new ZipInputShop(this, rof);
    }

    public OutputShop<ZipArchiveEntry> newOutputShop(FsConcurrentModel model, OutputSocket<?> output, @CheckForNull InputShop<ZipArchiveEntry> source) throws IOException {
        OutputStream out = output.newOutputStream();
        try {
            return new FsMultiplexedArchiveOutputShop((OutputShop)this.newZipOutputShop(model, out, (ZipInputShop)source), this.getPool());
        }
        catch (IOException ex) {
            out.close();
            throw ex;
        }
    }

    protected ZipOutputShop newZipOutputShop(FsConcurrentModel model, OutputStream out, @CheckForNull ZipInputShop source) throws IOException {
        return new ZipOutputShop(this, out, source);
    }
}

