/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class DateTimeConverter
extends Enum<DateTimeConverter> {
    public static final /* enum */ DateTimeConverter JAR = new DateTimeConverter(){

        @Override
        TimeZone newTimeZone() {
            return TimeZone.getDefault();
        }

        @Override
        boolean roundUp(long jTime) {
            return false;
        }
    };
    public static final /* enum */ DateTimeConverter ZIP = new DateTimeConverter(){

        @Override
        TimeZone newTimeZone() {
            TimeZone tz = TimeZone.getDefault();
            tz = new SimpleTimeZone(tz.getRawOffset() + tz.getDSTSavings(), tz.getID());
            assert (!tz.useDaylightTime());
            return tz;
        }

        @Override
        boolean roundUp(long jTime) {
            return true;
        }
    };
    static final long MIN_DOS_TIME = 0x210000L;
    static final long MAX_DOS_TIME = 4288659325L;
    private final ThreadLocal<GregorianCalendar> calendar = new ThreadLocalGregorianCalendar();
    private static final /* synthetic */ DateTimeConverter[] $VALUES;

    public static DateTimeConverter[] values() {
        return (DateTimeConverter[])$VALUES.clone();
    }

    public static DateTimeConverter valueOf(String name) {
        return Enum.valueOf(DateTimeConverter.class, name);
    }

    abstract TimeZone newTimeZone();

    abstract boolean roundUp(long var1);

    private GregorianCalendar getGregorianCalendar() {
        return this.calendar.get();
    }

    final long toDosTime(long jTime) {
        if (jTime < 0L) {
            throw new IllegalArgumentException("Java time is negative: 0x" + Long.toHexString(jTime).toUpperCase(Locale.ENGLISH));
        }
        GregorianCalendar cal = this.getGregorianCalendar();
        cal.setTimeInMillis(this.roundUp(jTime) ? jTime + 1999L : jTime);
        long dTime = cal.get(1) - 1980;
        if (dTime < 0L) {
            return 0x210000L;
        }
        if (4288659325L < (dTime = dTime << 25 | (long)(cal.get(2) + 1 << 21) | (long)(cal.get(5) << 16) | (long)(cal.get(11) << 11) | (long)(cal.get(12) << 5) | (long)(cal.get(13) >> 1))) {
            throw new IllegalArgumentException("Java time is later than 2107 AD: 0x" + Long.toHexString(jTime).toUpperCase(Locale.ENGLISH));
        }
        assert (0x210000L <= dTime && dTime <= 4288659325L);
        return dTime;
    }

    final long toJavaTime(long dTime) {
        if (dTime < 0x210000L) {
            throw new IllegalArgumentException("DOS date/time is earlier than 1980 AD: 0x" + Long.toHexString(dTime).toUpperCase(Locale.ENGLISH));
        }
        if (4288659325L < dTime) {
            throw new IllegalArgumentException("DOS date/time is later than 2107 AD: 0x" + Long.toHexString(dTime).toUpperCase(Locale.ENGLISH));
        }
        int time = (int)dTime;
        GregorianCalendar cal = this.getGregorianCalendar();
        cal.set(1, 1980 + (time >> 25 & 0x7F));
        cal.set(2, (time >> 21 & 0xF) - 1);
        cal.set(5, time >> 16 & 0x1F);
        cal.set(11, time >> 11 & 0x1F);
        cal.set(12, time >> 5 & 0x3F);
        cal.set(13, time << 1 & 0x3E);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    static {
        $VALUES = new DateTimeConverter[]{JAR, ZIP};
    }

    private final class ThreadLocalGregorianCalendar
    extends ThreadLocal<GregorianCalendar> {
        private ThreadLocalGregorianCalendar() {
        }

        @Override
        protected GregorianCalendar initialValue() {
            return new GregorianCalendar(DateTimeConverter.this.newTimeZone());
        }
    }
}

