/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.util.ArrayHelper;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ManySmallEntriesTest {
    private static final Logger logger = Logger.getLogger(ManySmallEntriesTest.class.getName());
    private static final byte[] data = "Hello World!".getBytes();
    private static final long dataCrc = 472456355L;
    private File zip;

    @Before
    public void setUp() throws IOException {
        this.zip = File.createTempFile("zip", null);
    }

    @After
    public void tearDown() {
        Assert.assertTrue((boolean)this.zip.delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManySmallEntries() throws IOException {
        logger.fine("testManySmallEntries");
        int n = 70000;
        logger.log(Level.FINER, "Compressing {0} ZIP file entries to: {1}", new Object[]{70000, this.zip.getPath()});
        logger.finer("Note that the max. number of entries supported by the ZIP File Format Spec. is 65535!");
        HashSet<String> set = new HashSet<String>();
        ZipOutputStream zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(this.zip));
        for (int i = 100000; i < 170000; ++i) {
            String name = i + ".txt";
            ZipEntry entry = new ZipEntry(name);
            entry.setSize((long)data.length);
            entry.setCompressedSize((long)data.length);
            entry.setCrc(472456355L);
            entry.setMethod(0);
            zipOut.putNextEntry(entry);
            zipOut.write(data);
            Assert.assertTrue((boolean)set.add(name));
        }
        zipOut.close();
        logger.log(Level.FINER, "Compressed {0} ZIP file entries into {1} KB ZIP file length.", new Object[]{70000, this.zip.length() / 1024L});
        ZipFile zipIn = new ZipFile(this.zip);
        try {
            byte[] buf = new byte[data.length];
            Enumeration e = zipIn.entries();
            while (e.hasMoreElements()) {
                int read;
                ZipEntry entry = (ZipEntry)e.nextElement();
                Assert.assertEquals((long)data.length, (long)entry.getSize());
                InputStream in = zipIn.getInputStream(entry);
                int off = 0;
                while ((read = in.read(buf)) >= 0) {
                    Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)ArrayHelper.equals((byte[])data, (int)off, (byte[])buf, (int)0, (int)read));
                    off += read;
                }
                Assert.assertEquals((long)-1L, (long)read);
                Assert.assertEquals((long)off, (long)data.length);
                Assert.assertEquals((long)0L, (long)in.read(new byte[0]));
                in.close();
                Assert.assertTrue((boolean)set.remove(entry.getName()));
            }
        }
        finally {
            zipIn.close();
        }
        Assert.assertTrue((boolean)set.isEmpty());
        logger.finer("Successfully decompressed the data in all entries.");
    }
}

