/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.io.SynchronizedInputStream;
import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.util.Pool;
import de.schlichtherle.truezip.zip.DefaultZipEntryFactory;
import de.schlichtherle.truezip.zip.RawZipFile;
import de.schlichtherle.truezip.zip.ZipEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;

public class ZipFile
extends RawZipFile<ZipEntry> {
    private final String name;

    public ZipFile(String path) throws IOException {
        this(path, DEFAULT_CHARSET, true, false);
    }

    public ZipFile(String path, Charset charset) throws IOException {
        this(path, charset, true, false);
    }

    public ZipFile(String path, Charset charset, boolean preambled, boolean postambled) throws IOException {
        super(new DefaultReadOnlyFilePool(path), charset, preambled, postambled, DefaultZipEntryFactory.SINGLETON);
        this.name = path;
    }

    public ZipFile(File file) throws IOException {
        this(file, DEFAULT_CHARSET, true, false);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        this(file, charset, true, false);
    }

    public ZipFile(File file, Charset charset, boolean preambled, boolean postambled) throws IOException {
        super(new DefaultReadOnlyFilePool(file), charset, preambled, postambled, DefaultZipEntryFactory.SINGLETON);
        this.name = file.toString();
    }

    public ZipFile(ReadOnlyFile rof) throws IOException {
        this(rof, DEFAULT_CHARSET, true, false);
    }

    public ZipFile(ReadOnlyFile rof, Charset charset) throws IOException {
        this(rof, charset, true, false);
    }

    public ZipFile(ReadOnlyFile rof, Charset charset, boolean preambled, boolean postambled) throws IOException {
        super(rof, charset, preambled, postambled, DefaultZipEntryFactory.SINGLETON);
        this.name = rof.toString();
    }

    public String getName() {
        return this.name;
    }

    public synchronized Enumeration<? extends ZipEntry> entries() {
        class CloneEnumeration
        implements Enumeration<ZipEntry> {
            final Iterator<ZipEntry> i;

            CloneEnumeration() {
                this.i = ZipFile.super.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public ZipEntry nextElement() {
                return this.i.next().clone();
            }
        }
        return new CloneEnumeration();
    }

    @Override
    public synchronized Iterator<ZipEntry> iterator() {
        class EntryIterator
        implements Iterator<ZipEntry> {
            final Iterator<ZipEntry> i;

            EntryIterator() {
                this.i = ZipFile.super.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public ZipEntry next() {
                return this.i.next().clone();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new EntryIterator();
    }

    @Override
    public synchronized ZipEntry getEntry(String name) {
        Object ze = super.getEntry(name);
        return ze != null ? ((ZipEntry)ze).clone() : null;
    }

    @Override
    public synchronized InputStream getPreambleInputStream() throws IOException {
        return new SynchronizedInputStream(super.getPreambleInputStream(), (Object)this);
    }

    @Override
    public synchronized InputStream getPostambleInputStream() throws IOException {
        return new SynchronizedInputStream(super.getPostambleInputStream(), (Object)this);
    }

    @Override
    public synchronized boolean busy() {
        return super.busy();
    }

    @Override
    protected synchronized InputStream getInputStream(String name, boolean check, boolean inflate) throws IOException {
        InputStream in = super.getInputStream(name, check, inflate);
        return in != null ? new SynchronizedInputStream(in, (Object)this) : null;
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
    }

    private static class DefaultReadOnlyFilePool
    implements Pool<ReadOnlyFile, IOException> {
        final File file;

        public DefaultReadOnlyFilePool(File file) {
            this.file = file;
        }

        public DefaultReadOnlyFilePool(String name) {
            this.file = new File(name);
        }

        public ReadOnlyFile allocate() throws IOException {
            return new DefaultReadOnlyFile(this.file);
        }

        public void release(ReadOnlyFile rof) throws IOException {
            rof.close();
        }
    }
}

