/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.rof.BufferedReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.util.Pool;
import de.schlichtherle.truezip.zip.CRC32Exception;
import de.schlichtherle.truezip.zip.InflaterPool;
import de.schlichtherle.truezip.zip.LittleEndian;
import de.schlichtherle.truezip.zip.ZipConstants;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipEntryFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public abstract class RawZipFile<E extends ZipEntry>
implements Iterable<E>,
Closeable {
    private static final int LFH_FILE_NAME_LENGTH_OFF = 26;
    public static final Charset DEFAULT_CHARSET = ZipConstants.DEFAULT_CHARSET;
    private final Map<String, E> entries = new LinkedHashMap<String, E>();
    private Charset charset;
    private String comment;
    private long length = -1L;
    private long preamble;
    private long postamble;
    private OffsetMapper mapper;
    private final ZipEntryFactory<E> factory;
    private ReadOnlyFile archive;
    private int openStreams;

    protected RawZipFile(@NonNull ReadOnlyFile archive, @NonNull Charset charset, boolean preambled, boolean postambled, @NonNull ZipEntryFactory<E> factory) throws IOException {
        this(new SingletonReadOnlyFilePool(archive), charset, preambled, postambled, factory);
    }

    RawZipFile(@NonNull Pool<ReadOnlyFile, IOException> source, @NonNull Charset charset, boolean preambled, boolean postambled, @NonNull ZipEntryFactory<E> factory) throws IOException {
        if (charset == null || factory == null) {
            throw new NullPointerException();
        }
        ReadOnlyFile rof = (ReadOnlyFile)source.allocate();
        try {
            this.archive = rof;
            this.charset = charset;
            this.factory = factory;
            BufferedReadOnlyFile brof = rof instanceof BufferedReadOnlyFile ? (BufferedReadOnlyFile)rof : new BufferedReadOnlyFile(rof);
            this.mountCentralDirectory((ReadOnlyFile)brof, preambled, postambled);
        }
        catch (IOException ex) {
            source.release((Object)rof);
            throw ex;
        }
        assert (rof != null);
        assert (charset != null);
        assert (this.mapper != null);
    }

    private void mountCentralDirectory(ReadOnlyFile rof, boolean preambled, boolean postambled) throws IOException {
        int numEntries = this.findCentralDirectory(rof, preambled, postambled);
        assert (this.mapper != null);
        this.preamble = Long.MAX_VALUE;
        byte[] sig = new byte[4];
        byte[] cfh = new byte[46 - sig.length];
        while (true) {
            boolean utf8;
            rof.readFully(sig);
            if (LittleEndian.readUInt(sig, 0) != 33639248L) break;
            rof.readFully(cfh);
            int general = LittleEndian.readUShort(cfh, 4);
            int nameLen = LittleEndian.readUShort(cfh, 24);
            byte[] name = new byte[nameLen];
            rof.readFully(name);
            boolean bl = utf8 = (general & 0x800) != 0;
            if (utf8) {
                this.charset = ZipConstants.UTF8;
            }
            E entry = this.factory.newEntry(this.decode(name));
            try {
                int off = 0;
                int versionMadeBy = LittleEndian.readUShort(cfh, off);
                off += 2;
                ((ZipEntry)entry).setPlatform((short)(versionMadeBy >> 8));
                off += 2;
                ((ZipEntry)entry).setGeneral(general);
                off += 2;
                assert (((ZipEntry)entry).getGeneralBit(11) == utf8);
                int method = LittleEndian.readUShort(cfh, off);
                off += 2;
                if (method != 0 && method != 8) {
                    throw new ZipException(((ZipEntry)entry).getName() + " (unsupported compression method: " + method + ")");
                }
                ((ZipEntry)entry).setMethod(method);
                ((ZipEntry)entry).setDosTime(LittleEndian.readUInt(cfh, off));
                ((ZipEntry)entry).setCrc(LittleEndian.readUInt(cfh, off += 4));
                ((ZipEntry)entry).setCompressedSize32(LittleEndian.readUInt(cfh, off += 4));
                ((ZipEntry)entry).setSize32(LittleEndian.readUInt(cfh, off += 4));
                off += 4;
                int extraLen = LittleEndian.readUShort(cfh, off += 2);
                int commentLen = LittleEndian.readUShort(cfh, off += 2);
                off += 2;
                off += 2;
                off += 2;
                long lfhOff = LittleEndian.readUInt(cfh, off += 4);
                ((ZipEntry)entry).setOffset32(lfhOff);
                if (extraLen > 0) {
                    byte[] extra = new byte[extraLen];
                    rof.readFully(extra);
                    ((ZipEntry)entry).setExtra(extra);
                }
                if (commentLen > 0) {
                    byte[] comment = new byte[commentLen];
                    rof.readFully(comment);
                    ((ZipEntry)entry).setComment(this.decode(comment));
                }
                if ((lfhOff = this.mapper.location(((ZipEntry)entry).getOffset())) < this.preamble) {
                    this.preamble = lfhOff;
                }
            }
            catch (RuntimeException incompatibleZipFile) {
                ZipException exc = new ZipException(((ZipEntry)entry).getName());
                exc.initCause(incompatibleZipFile);
                throw exc;
            }
            this.entries.put(((ZipEntry)entry).getName(), entry);
            --numEntries;
        }
        if (numEntries % 65536 != 0) {
            throw new ZipException("Expected " + Math.abs(numEntries) + (numEntries > 0 ? " more" : " less") + " entries in the Central Directory!");
        }
        if (this.preamble == Long.MAX_VALUE) {
            this.preamble = 0L;
        }
    }

    private String decode(byte[] bytes) {
        return this.charset.decode(ByteBuffer.wrap(bytes)).toString();
    }

    private int findCentralDirectory(ReadOnlyFile rof, boolean preambled, boolean postambled) throws ZipException, IOException {
        byte[] sig = new byte[4];
        if (!preambled) {
            rof.seek(0L);
            rof.readFully(sig);
            long signature = LittleEndian.readUInt(sig, 0);
            boolean bl = preambled = signature == 67324752L || signature == 101075792L || signature == 101010256L;
        }
        if (preambled) {
            this.length = rof.length();
            long max = this.length - 22L;
            long min = !postambled && max >= 65535L ? max - 65535L : 0L;
            for (long eocdrOffset = max; eocdrOffset >= min; --eocdrOffset) {
                rof.seek(eocdrOffset);
                rof.readFully(sig);
                if (LittleEndian.readUInt(sig, 0) != 101010256L) continue;
                int off = 0;
                byte[] eocdr = new byte[22 - sig.length];
                rof.readFully(eocdr);
                long diskNo = LittleEndian.readUShort(eocdr, off);
                long cdDiskNo = LittleEndian.readUShort(eocdr, off += 2);
                long cdEntriesDisk = LittleEndian.readUShort(eocdr, off += 2);
                long cdEntries = LittleEndian.readUShort(eocdr, off += 2);
                off += 2;
                if (diskNo != 0L || cdDiskNo != 0L || cdEntriesDisk != cdEntries) {
                    throw new ZipException("ZIP file spanning/splitting is not supported!");
                }
                long cdSize = LittleEndian.readUInt(eocdr, off);
                long cdOffset = LittleEndian.readUInt(eocdr, off += 4);
                int commentLen = LittleEndian.readUShort(eocdr, off += 4);
                if (commentLen > 0) {
                    byte[] comment = new byte[commentLen];
                    rof.readFully(comment);
                    this.setComment(this.decode(comment));
                }
                this.postamble = this.length - rof.getFilePointer();
                try {
                    byte[] zip64eocdl = new byte[20];
                    rof.seek(eocdrOffset - 20L);
                    rof.readFully(zip64eocdl);
                    off = 0;
                    long zip64eocdlSig = LittleEndian.readUInt(zip64eocdl, off);
                    off += 4;
                    if (zip64eocdlSig != 117853008L) {
                        throw new IOException("Expected ZIP64 End Of Central Directory Locator signature!");
                    }
                    long zip64eocdrDisk = LittleEndian.readUInt(zip64eocdl, off);
                    long zip64eocdrOffset = LittleEndian.readLong(zip64eocdl, off += 4);
                    long totalDisks = LittleEndian.readUInt(zip64eocdl, off += 8);
                    if (zip64eocdrDisk != 0L || totalDisks != 1L) {
                        throw new ZipException("ZIP file spanning/splitting is not supported!");
                    }
                    byte[] zip64eocdr = new byte[56];
                    rof.seek(zip64eocdrOffset);
                    rof.readFully(zip64eocdr);
                    off = 0;
                    long zip64eocdrSig = LittleEndian.readUInt(zip64eocdr, off);
                    off += 4;
                    if (zip64eocdrSig != 101075792L) {
                        throw new ZipException("Expected ZIP64 End Of Central Directory Record signature!");
                    }
                    off += 8;
                    off += 2;
                    diskNo = LittleEndian.readUInt(zip64eocdr, off += 2);
                    cdDiskNo = LittleEndian.readUInt(zip64eocdr, off += 4);
                    cdEntriesDisk = LittleEndian.readLong(zip64eocdr, off += 4);
                    cdEntries = LittleEndian.readLong(zip64eocdr, off += 8);
                    off += 8;
                    if (diskNo != 0L || cdDiskNo != 0L || cdEntriesDisk != cdEntries) {
                        throw new ZipException("ZIP file spanning/splitting is not supported!");
                    }
                    if (cdEntries < 0L || Integer.MAX_VALUE < cdEntries) {
                        throw new ZipException("Total Number Of Entries In The Central Directory out of range!");
                    }
                    cdSize = LittleEndian.readLong(zip64eocdr, off);
                    cdOffset = LittleEndian.readLong(zip64eocdr, off += 8);
                    rof.seek(cdOffset);
                    this.mapper = new OffsetMapper();
                }
                catch (ZipException ze) {
                    throw ze;
                }
                catch (IOException ioe) {
                    long start = eocdrOffset - cdSize;
                    rof.seek(start);
                    this.mapper = (start -= cdOffset) != 0L ? new IrregularOffsetMapper(start) : new OffsetMapper();
                }
                return (int)cdEntries;
            }
        }
        throw new ZipException("Expected End Of Central Directory Record signature!");
    }

    public String getComment() {
        return this.comment;
    }

    private void setComment(String comment) {
        this.comment = comment;
    }

    public boolean busy() {
        return this.openStreams > 0;
    }

    public String getCharset() {
        return this.charset.name();
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.entries.values().iterator();
    }

    public E getEntry(String name) {
        return (E)((ZipEntry)this.entries.get(name));
    }

    public long length() {
        return this.length;
    }

    public long getPreambleLength() {
        return this.preamble;
    }

    public InputStream getPreambleInputStream() throws IOException {
        this.assertOpen();
        return new IntervalInputStream(0L, this.preamble);
    }

    public long getPostambleLength() {
        return this.postamble;
    }

    public InputStream getPostambleInputStream() throws IOException {
        this.assertOpen();
        return new IntervalInputStream(this.length - this.postamble, this.postamble);
    }

    OffsetMapper getOffsetMapper() {
        return this.mapper;
    }

    public boolean offsetsConsiderPreamble() {
        assert (this.mapper != null);
        return this.mapper.location(0L) == 0L;
    }

    public final InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name, false, true);
    }

    public final InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.getInputStream(entry.getName(), false, true);
    }

    public final InputStream getCheckedInputStream(String name) throws IOException {
        return this.getInputStream(name, true, true);
    }

    public final InputStream getCheckedInputStream(ZipEntry entry) throws IOException {
        return this.getInputStream(entry.getName(), true, true);
    }

    protected InputStream getInputStream(String name, boolean check, boolean inflate) throws IOException {
        this.assertOpen();
        if (name == null) {
            throw new NullPointerException();
        }
        ZipEntry entry = (ZipEntry)this.entries.get(name);
        if (entry == null) {
            return null;
        }
        long offset = entry.getOffset();
        assert (offset != -1L);
        offset = this.mapper.location(offset);
        this.archive.seek(offset);
        byte[] lfh = new byte[30];
        this.archive.readFully(lfh);
        long lfhSig = LittleEndian.readUInt(lfh, 0);
        if (lfhSig != 67324752L) {
            throw new ZipException(name + " (expected Local File Header Signature)");
        }
        offset += (long)(30 + LittleEndian.readUShort(lfh, 26) + LittleEndian.readUShort(lfh, 28));
        if (check) {
            long localCrc;
            if (entry.getGeneralBit(3)) {
                byte[] dd = new byte[8];
                this.archive.seek(offset + entry.getCompressedSize());
                this.archive.readFully(dd);
                long ddSig = LittleEndian.readUInt(dd, 0);
                localCrc = ddSig == 134695760L ? LittleEndian.readUInt(dd, 4) : ddSig;
            } else {
                localCrc = LittleEndian.readUInt(lfh, 14);
            }
            if (entry.getCrc() != localCrc) {
                throw new CRC32Exception(name, entry.getCrc(), localCrc);
            }
        }
        IntervalInputStream iis = new IntervalInputStream(offset, entry.getCompressedSize());
        int bufSize = RawZipFile.getBufferSize(entry);
        Object in = iis;
        switch (entry.getMethod()) {
            case 8: {
                if (inflate) {
                    iis.addDummy();
                    in = new PooledInflaterInputStream((InputStream)in, bufSize);
                    if (!check) break;
                    in = new CheckedInputStream((InputStream)in, entry, bufSize);
                    break;
                }
                if (!check) break;
                in = new RawCheckedInputStream((InputStream)in, entry, bufSize);
                break;
            }
            case 0: {
                if (!check) break;
                in = new CheckedInputStream((InputStream)in, entry, bufSize);
                break;
            }
            default: {
                assert (false) : "This should already have been checked by mountCentralDirectory()!";
                break;
            }
        }
        return in;
    }

    private static int getBufferSize(ZipEntry entry) {
        long size = entry.getSize();
        if (size > 65536L) {
            size = 65536L;
        } else if (size < 8192L) {
            size = 8192L;
        }
        return (int)size;
    }

    final void assertOpen() throws ZipException {
        if (null == this.archive) {
            throw new ZipException("ZIP file closed!");
        }
    }

    private static long skipWithBuffer(InputStream in, long toSkip, byte[] buf) throws IOException {
        long len;
        long total = 0L;
        while ((len = toSkip - total) > 0L && (len = (long)in.read(buf, 0, len < (long)buf.length ? (int)len : buf.length)) >= 0L) {
            total += len;
        }
        return total;
    }

    @Override
    public void close() throws IOException {
        if (this.archive != null) {
            ReadOnlyFile oldArchive = this.archive;
            this.archive = null;
            oldArchive.close();
        }
    }

    private static class IrregularOffsetMapper
    extends OffsetMapper {
        final long start;

        IrregularOffsetMapper(long start) {
            this.start = start;
        }

        @Override
        long location(long offset) {
            return this.start + offset;
        }
    }

    static class OffsetMapper {
        OffsetMapper() {
        }

        long location(long offset) {
            return offset;
        }
    }

    private abstract class AccountedInputStream
    extends InputStream {
        private boolean closed;

        public AccountedInputStream() {
            RawZipFile.this.openStreams++;
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            RawZipFile.this.openStreams--;
            super.close();
        }
    }

    private class IntervalInputStream
    extends AccountedInputStream {
        private long remaining;
        private long fp;
        private boolean addDummyByte;

        IntervalInputStream(long start, long remaining) {
            assert (start >= 0L);
            assert (remaining >= 0L);
            this.remaining = remaining;
            this.fp = start;
        }

        @Override
        public int read() throws IOException {
            RawZipFile.this.assertOpen();
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            RawZipFile.this.archive.seek(this.fp);
            int ret = RawZipFile.this.archive.read();
            if (ret >= 0) {
                ++this.fp;
                --this.remaining;
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len <= 0) {
                if (len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                return 0;
            }
            RawZipFile.this.assertOpen();
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    b[off] = 0;
                    return 1;
                }
                return -1;
            }
            if ((long)len > this.remaining) {
                len = (int)this.remaining;
            }
            RawZipFile.this.archive.seek(this.fp);
            int ret = RawZipFile.this.archive.read(b, off, len);
            if (ret > 0) {
                this.fp += (long)ret;
                this.remaining -= (long)ret;
            }
            return ret;
        }

        void addDummy() {
            this.addDummyByte = true;
        }

        @Override
        public int available() throws IOException {
            RawZipFile.this.assertOpen();
            long available = this.remaining;
            if (this.addDummyByte) {
                ++available;
            }
            return available > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)available;
        }
    }

    private static final class RawCheckedInputStream
    extends DecoratingInputStream {
        private final Checksum crc = new CRC32();
        private final byte[] singleByteBuf = new byte[1];
        private final Inflater inf = InflaterPool.fetch();
        private final byte[] infBuf;
        private final ZipEntry entry;
        private boolean closed;

        public RawCheckedInputStream(InputStream in, ZipEntry entry, int size) {
            super(in);
            this.infBuf = new byte[size];
            this.entry = entry;
        }

        private void ensureOpen() throws IOException {
            if (this.closed) {
                throw new IOException("Input stream has been closed!");
            }
        }

        public int read() throws IOException {
            int read;
            while ((read = this.read(this.singleByteBuf, 0, 1)) == 0) {
            }
            return read > 0 ? this.singleByteBuf[0] & 0xFF : -1;
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            this.ensureOpen();
            if (buf == null) {
                throw new NullPointerException();
            }
            int offPlusLen = off + len;
            if ((off | len | offPlusLen | buf.length - offPlusLen) < 0) {
                throw new IndexOutOfBoundsException();
            }
            int read = this.delegate.read(buf, off, len);
            if (read >= 0) {
                this.inf.setInput(buf, off, read);
            } else {
                buf[off] = 0;
                this.inf.setInput(buf, off, 1);
            }
            try {
                int inflated;
                while ((inflated = this.inf.inflate(this.infBuf, 0, this.infBuf.length)) > 0) {
                    this.crc.update(this.infBuf, 0, inflated);
                }
            }
            catch (DataFormatException ex) {
                throw new IOException(ex);
            }
            assert (read >= 0 || this.inf.finished());
            assert (read < 0 || this.inf.needsInput());
            assert (!this.inf.needsDictionary());
            return read;
        }

        public long skip(long toSkip) throws IOException {
            return RawZipFile.skipWithBuffer((InputStream)((Object)this), toSkip, new byte[this.infBuf.length]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            long actualCrc;
            if (this.closed) {
                return;
            }
            try {
                while (this.skip(Long.MAX_VALUE) > 0L) {
                }
            }
            finally {
                this.closed = true;
                InflaterPool.release(this.inf);
                super.close();
            }
            long expectedCrc = this.entry.getCrc();
            if (expectedCrc != (actualCrc = this.crc.getValue())) {
                throw new CRC32Exception(this.entry.getName(), expectedCrc, actualCrc);
            }
        }

        public void mark(int readlimit) {
        }

        public void reset() throws IOException {
            throw new IOException("mark()/reset() is not supported!");
        }

        public boolean markSupported() {
            return false;
        }
    }

    private static final class CheckedInputStream
    extends java.util.zip.CheckedInputStream {
        private final ZipEntry entry;
        private final int size;

        public CheckedInputStream(InputStream in, ZipEntry entry, int size) {
            super(in, new CRC32());
            this.entry = entry;
            this.size = size;
        }

        @Override
        public long skip(long toSkip) throws IOException {
            return RawZipFile.skipWithBuffer(this, toSkip, new byte[this.size]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            long actualCrc;
            try {
                while (this.skip(Long.MAX_VALUE) > 0L) {
                }
            }
            finally {
                super.close();
            }
            long expectedCrc = this.entry.getCrc();
            if (expectedCrc != (actualCrc = this.getChecksum().getValue())) {
                throw new CRC32Exception(this.entry.getName(), expectedCrc, actualCrc);
            }
        }
    }

    private static final class PooledInflaterInputStream
    extends InflaterInputStream {
        private boolean closed;

        public PooledInflaterInputStream(InputStream in, int size) {
            super(in, InflaterPool.fetch(), size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                super.close();
            }
            finally {
                InflaterPool.release(this.inf);
            }
        }
    }

    private static class SingletonReadOnlyFilePool
    implements Pool<ReadOnlyFile, IOException> {
        final ReadOnlyFile rof;

        public SingletonReadOnlyFilePool(ReadOnlyFile rof) {
            this.rof = rof;
        }

        public ReadOnlyFile allocate() {
            return this.rof;
        }

        public void release(ReadOnlyFile rof) {
            assert (this.rof == rof);
        }
    }
}

