/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.LittleEndian;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class LittleEndianTest {
    private static final byte[] DATA = new byte[]{0, 85, -86, 85, -86, 85, -86, 85, -86};
    private byte[] read;
    private byte[] write;

    @Before
    public void setUp() {
        this.read = (byte[])DATA.clone();
        this.write = new byte[this.read.length];
    }

    @Test
    public void testShort() {
        short s = LittleEndian.readShort((byte[])this.read, (int)1);
        Assert.assertEquals((long)-21931L, (long)s);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)1);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)3);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)5);
        LittleEndian.writeShort((int)s, (byte[])this.write, (int)7);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }

    @Test
    public void testUShort() {
        int s = LittleEndian.readUShort((byte[])this.read, (int)1);
        Assert.assertEquals((long)43605L, (long)s);
        LittleEndian.writeShort((int)((short)s), (byte[])this.write, (int)1);
        LittleEndian.writeShort((int)((short)s), (byte[])this.write, (int)3);
        LittleEndian.writeShort((int)((short)s), (byte[])this.write, (int)5);
        LittleEndian.writeShort((int)((short)s), (byte[])this.write, (int)7);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }

    @Test
    public void testInt() {
        int i = LittleEndian.readInt((byte[])this.read, (int)1);
        Assert.assertEquals((long)-1437226411L, (long)i);
        LittleEndian.writeInt((int)i, (byte[])this.write, (int)1);
        LittleEndian.writeInt((int)i, (byte[])this.write, (int)5);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }

    @Test
    public void testUInt() {
        long i = LittleEndian.readUInt((byte[])this.read, (int)1);
        Assert.assertEquals((long)0xAA55AA55L, (long)i);
        LittleEndian.writeInt((int)((int)i), (byte[])this.write, (int)1);
        LittleEndian.writeInt((int)((int)i), (byte[])this.write, (int)5);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }

    @Test
    public void testLong() {
        long l = LittleEndian.readLong((byte[])this.read, (int)1);
        Assert.assertEquals((long)-6172840429334713771L, (long)l);
        LittleEndian.writeLong((long)l, (byte[])this.write, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(this.read, this.write));
    }
}

