/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.zip.DateTimeConverter;
import de.schlichtherle.truezip.zip.ZipEntry;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;

@DefaultAnnotation(value={NonNull.class})
public class ZipArchiveEntry
extends ZipEntry
implements FsArchiveEntry {
    ZipArchiveEntry(String name) {
        super(name);
    }

    ZipArchiveEntry(String name, ZipEntry template) {
        super(name, template);
    }

    public Entry.Type getType() {
        return this.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
    }

    @Override
    protected DateTimeConverter getDateTimeConverter() {
        return DateTimeConverter.ZIP;
    }

    public long getSize(Entry.Size type) {
        switch (type) {
            case DATA: {
                return this.getSize();
            }
            case STORAGE: {
                return this.getCompressedSize();
            }
        }
        return -1L;
    }

    public boolean setSize(Entry.Size type, long size) {
        if (Entry.Size.DATA != type) {
            return false;
        }
        this.setSize(size);
        return true;
    }

    public long getTime(Entry.Access type) {
        if (Entry.Access.WRITE != type) {
            return -1L;
        }
        long time = this.getTime();
        return 0L <= time ? time : -1L;
    }

    public boolean setTime(Entry.Access type, long time) {
        if (Entry.Access.WRITE != type) {
            return false;
        }
        this.setTime(time);
        return true;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(this.getClass().getName()).append("[name=").append(this.getName()).append(",type=").append(this.getType());
        for (Entry.Size type : ALL_SIZE_SET) {
            s.append(",size(").append(type).append(")=").append(this.getSize(type));
        }
        for (Entry.Size type : ALL_ACCESS_SET) {
            s.append(",time(").append(type).append(")=").append(this.getTime((Entry.Access)type));
        }
        return s.append("]").toString();
    }
}

