/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.fs.archive.FsMultiplexedArchiveOutputShop;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipOutputShop;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class OdfOutputShop
extends FsMultiplexedArchiveOutputShop<ZipArchiveEntry> {
    private static final String MIMETYPE = "mimetype";
    private boolean mimetype;

    public OdfOutputShop(ZipOutputShop delegate, IOPool<?> pool) {
        super((OutputShop)delegate, pool);
    }

    public OutputSocket<ZipArchiveEntry> getOutputSocket(final ZipArchiveEntry entry) {
        if (null == entry) {
            throw new NullPointerException();
        }
        class Output
        extends DecoratingOutputSocket<ZipArchiveEntry> {
            Output() {
                super(OdfOutputShop.super.getOutputSocket(zipArchiveEntry));
            }

            public OutputStream newOutputStream() throws IOException {
                if (OdfOutputShop.MIMETYPE.equals(entry.getName())) {
                    OdfOutputShop.this.mimetype = true;
                    if (-1 == entry.getMethod()) {
                        entry.setMethod(0);
                    }
                }
                return super.newOutputStream();
            }
        }
        return new Output();
    }

    public boolean isBusy() {
        return !this.mimetype || super.isBusy();
    }

    public void close() throws IOException {
        this.mimetype = true;
        super.close();
    }
}

