/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.ExtraField;
import de.schlichtherle.truezip.zip.UShort;

final class DefaultExtraField
extends ExtraField {
    private final int headerID;
    private byte[] data;

    DefaultExtraField(int headerID) {
        UShort.check(headerID, "Header ID out of range", null);
        this.headerID = headerID;
    }

    @Override
    public int getHeaderID() {
        return this.headerID;
    }

    @Override
    int getDataSize() {
        return this.data != null ? this.data.length : 0;
    }

    @Override
    void readFrom(byte[] data, int off, int size) {
        UShort.check(size, "Data Size out of range", null);
        this.data = new byte[size];
        System.arraycopy(data, off, this.data, 0, size);
    }

    @Override
    void writeTo(byte[] data, int off) {
        if (this.data != null) {
            System.arraycopy(this.data, 0, data, off, this.data.length);
        }
    }
}

