/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.DefaultExtraField;
import de.schlichtherle.truezip.zip.ExtraField;
import org.junit.Assert;
import org.junit.Test;

public final class ExtraFieldTest {
    @Test
    public void testRegister() {
        try {
            ExtraField.register(null);
            Assert.fail((String)"Expected IllegalArgumentException!");
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            ExtraField.register(TooSmallHeaderIDExtraField.class);
            Assert.fail((String)"Expected IllegalArgumentException!");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            ExtraField.register(TooLargeHeaderIDExtraField.class);
            Assert.fail((String)"Expected IllegalArgumentException!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ExtraField.register(NullExtraField.class);
    }

    @Test
    public void testCreate() {
        ExtraField.register(NullExtraField.class);
        ExtraField ef = ExtraField.create((int)0);
        Assert.assertTrue((boolean)(ef instanceof NullExtraField));
        Assert.assertEquals((long)0L, (long)ef.getHeaderID());
        ef = ExtraField.create((int)1);
        Assert.assertTrue((boolean)(ef instanceof DefaultExtraField));
        Assert.assertEquals((long)1L, (long)ef.getHeaderID());
        ef = ExtraField.create((int)2);
        Assert.assertTrue((boolean)(ef instanceof DefaultExtraField));
        Assert.assertEquals((long)2L, (long)ef.getHeaderID());
        ef = ExtraField.create((int)65535);
        Assert.assertTrue((boolean)(ef instanceof DefaultExtraField));
        Assert.assertEquals((long)65535L, (long)ef.getHeaderID());
        try {
            ef = ExtraField.create((int)-1);
            Assert.fail((String)"Expected IllegalArgumentException!");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            ef = ExtraField.create((int)65536);
            Assert.fail((String)"Expected IllegalArgumentException!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static class TooLargeHeaderIDExtraField
    extends NullExtraField {
        private TooLargeHeaderIDExtraField() {
        }

        @Override
        public int getHeaderID() {
            return 65536;
        }
    }

    private static class TooSmallHeaderIDExtraField
    extends NullExtraField {
        private TooSmallHeaderIDExtraField() {
        }

        @Override
        public int getHeaderID() {
            return -1;
        }
    }

    private static class NullExtraField
    extends ExtraField {
        public int getHeaderID() {
            return 0;
        }

        int getDataSize() {
            return 0;
        }

        void readFrom(byte[] data, int off, int size) {
        }

        void writeTo(byte[] data, int off) {
        }
    }
}

