/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.util.ArrayHelper;
import de.schlichtherle.truezip.zip.CRC32Exception;
import de.schlichtherle.truezip.zip.ZipConstants;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ZipTestSuite {
    private static final Logger logger = Logger.getLogger(ZipTestSuite.class.getName());
    protected static final String TEMP_FILE_PREFIX = "tzp";
    private static final Random rnd = new Random();
    private static final byte[] DATA;
    private File zip;
    private byte[] data;

    @Before
    public void setUp() throws IOException {
        this.zip = File.createTempFile(TEMP_FILE_PREFIX, null);
        Assert.assertTrue((boolean)this.zip.delete());
        this.data = (byte[])DATA.clone();
    }

    protected final File getZip() {
        return this.zip;
    }

    protected final byte[] getData() {
        return (byte[])this.data.clone();
    }

    @After
    public void tearDown() throws IOException {
        if (this.zip.exists() && !this.zip.delete()) {
            logger.log(Level.WARNING, "{0} (could not delete)", this.zip);
        }
    }

    protected ZipOutputStream newZipOutputStream(OutputStream out) throws IOException {
        return new ZipOutputStream(out);
    }

    protected ZipOutputStream newZipOutputStream(OutputStream out, Charset charset) throws IOException {
        return new ZipOutputStream(out, charset);
    }

    protected ZipOutputStream newZipOutputStream(OutputStream out, ZipFile appendee) throws ZipException {
        return new ZipOutputStream(out, appendee);
    }

    protected ZipFile newZipFile(String name) throws IOException {
        return new ZipFile(name);
    }

    protected ZipFile newZipFile(String name, Charset charset) throws IOException {
        return new ZipFile(name, charset);
    }

    protected ZipFile newZipFile(File file) throws IOException {
        return new ZipFile(file);
    }

    protected ZipFile newZipFile(File file, Charset charset) throws IOException {
        return new ZipFile(file, charset);
    }

    protected ZipFile newZipFile(ReadOnlyFile file) throws IOException {
        return new ZipFile(file);
    }

    protected ZipFile newZipFile(ReadOnlyFile file, Charset charset) throws IOException {
        return new ZipFile(file, charset);
    }

    @Test
    public final void testConstructors() throws Exception {
        FileOutputStream os = new FileOutputStream(this.zip);
        ((OutputStream)os).write(this.data);
        ((OutputStream)os).close();
        DefaultReadOnlyFile rof = new DefaultReadOnlyFile(this.zip);
        try {
            this.newZipOutputStream(null, (Charset)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipOutputStream(null, (ZipFile)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipOutputStream((OutputStream)new ByteArrayOutputStream(), (Charset)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipOutputStream((OutputStream)new ByteArrayOutputStream(), (ZipFile)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipOutputStream(null, Charset.forName("UTF-8"));
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((String)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((String)null, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((String)null, Charset.forName("UTF-8"));
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile(this.zip.getPath(), null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((File)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((File)null, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((File)null, Charset.forName("UTF-8"));
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile(this.zip, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((ReadOnlyFile)null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((ReadOnlyFile)null, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((ReadOnlyFile)null, Charset.forName("UTF-8"));
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((ReadOnlyFile)rof, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.newZipFile(this.zip.getPath());
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            this.newZipFile(this.zip);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((ReadOnlyFile)rof);
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            this.newZipFile(this.zip, Charset.forName("UTF-8"));
            Assert.fail();
        }
        catch (IOException expected) {
            // empty catch block
        }
        try {
            this.newZipFile((ReadOnlyFile)rof, Charset.forName("UTF-8"));
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        rof.close();
        Assert.assertTrue((boolean)this.zip.delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testPreambleOfEmptyZipFile() throws IOException {
        this.newZipOutputStream(new FileOutputStream(this.zip)).close();
        ZipFile zipIn = this.newZipFile(this.zip);
        try {
            Assert.assertEquals((long)0L, (long)zipIn.getPreambleLength());
            InputStream in = zipIn.getPreambleInputStream();
            try {
                Assert.assertEquals((long)-1L, (long)in.read());
            }
            finally {
                in.close();
            }
        }
        finally {
            zipIn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void testGetInputStream() throws IOException {
        ZipOutputStream zipOut = this.newZipOutputStream(new FileOutputStream(this.zip));
        try {
            zipOut.putNextEntry(new ZipEntry("foo"));
        }
        finally {
            zipOut.close();
        }
        ZipFile zipIn = this.newZipFile(this.zip);
        try {
            zipIn.getInputStream("foo").close();
            Assert.assertNull((Object)zipIn.getInputStream("bar"));
        }
        finally {
            zipIn.close();
        }
    }

    @Test
    public final void testWriteAndReadSingleBytes() throws IOException {
        int c;
        ZipOutputStream zipOut = this.newZipOutputStream(new FileOutputStream(this.zip));
        zipOut.putNextEntry(new ZipEntry("file"));
        for (int i = 0; i < this.data.length; ++i) {
            zipOut.write((int)this.data[i]);
        }
        zipOut.close();
        ZipFile zipIn = this.newZipFile(this.zip);
        InputStream in = zipIn.getInputStream("file");
        int i = 0;
        while ((c = in.read()) != -1) {
            Assert.assertEquals((long)(this.data[i] & 0xFF), (long)c);
            ++i;
        }
        in.close();
        zipIn.close();
    }

    @Test
    public final void testMultithreading() throws Exception {
        this.multithreading(20, 40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void multithreading(final int nEntries, int nThreads) throws Exception {
        this.createTestZipFile(nEntries);
        final ZipFile zipIn = this.newZipFile(this.zip);
        try {
            class CheckAllEntriesThread
            extends Thread {
                Throwable failure;

                CheckAllEntriesThread() {
                    this.setDaemon(true);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ArrayList<ZipEntry> entries = Collections.list(zipIn.entries());
                        assert (entries.size() == nEntries);
                        for (int i = 0; i < nEntries; ++i) {
                            int j = rnd.nextInt(nEntries);
                            ZipEntry temp = (ZipEntry)entries.get(i);
                            entries.set(i, (ZipEntry)entries.get(j));
                            entries.set(j, temp);
                        }
                        byte[] buf = new byte[4096];
                        for (ZipEntry entry : entries) {
                            InputStream in = zipIn.getInputStream(entry.getName());
                            try {
                                int read;
                                int off = 0;
                                while ((read = in.read(buf)) >= 0) {
                                    Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                                    Assert.assertTrue((boolean)ArrayHelper.equals((byte[])ZipTestSuite.this.data, (int)off, (byte[])buf, (int)0, (int)read));
                                    off += read;
                                }
                                Assert.assertEquals((long)-1L, (long)read);
                                Assert.assertEquals((long)off, (long)ZipTestSuite.this.data.length);
                                Assert.assertEquals((long)0L, (long)in.read(new byte[0]));
                            }
                            finally {
                                in.close();
                            }
                        }
                    }
                    catch (Throwable t) {
                        this.failure = t;
                    }
                }
            }
            CheckAllEntriesThread thread;
            int i;
            CheckAllEntriesThread[] threads = new CheckAllEntriesThread[nThreads];
            for (i = 0; i < nThreads; ++i) {
                thread = new CheckAllEntriesThread();
                thread.start();
                threads[i] = thread;
            }
            i = 0;
            while (i < nThreads) {
                thread = threads[i];
                try {
                    thread.join();
                }
                catch (InterruptedException ignored) {
                    continue;
                }
                if (thread.failure != null) {
                    throw new Exception(thread.failure);
                }
                ++i;
            }
        }
        finally {
            zipIn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestZipFile(int nEntries) throws IOException {
        HashSet<String> set = new HashSet<String>();
        ZipOutputStream zipOut = this.newZipOutputStream(new FileOutputStream(this.zip));
        try {
            for (int i = 0; i < nEntries; ++i) {
                String name = i + ".txt";
                zipOut.putNextEntry(new ZipEntry(name));
                zipOut.write(this.data);
                Assert.assertTrue((boolean)set.add(name));
            }
        }
        finally {
            zipOut.close();
        }
        zipOut = null;
        ZipFile zipIn = this.newZipFile(this.zip);
        try {
            Enumeration e = zipIn.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)e.nextElement();
                Assert.assertEquals((long)this.data.length, (long)entry.getSize());
                Assert.assertTrue((boolean)set.remove(entry.getName()));
            }
            Assert.assertTrue((boolean)set.isEmpty());
        }
        finally {
            zipIn.close();
        }
    }

    @Test
    public final void testGoodGetCheckedInputStream() throws IOException {
        String name = "entry";
        ZipOutputStream zipOut = this.newZipOutputStream(new FileOutputStream(this.zip));
        zipOut.putNextEntry(new ZipEntry("entry"));
        zipOut.write(this.data);
        zipOut.close();
        ZipFile zipIn = this.newZipFile(this.zip);
        InputStream in = zipIn.getCheckedInputStream("entry");
        in.close();
        in = zipIn.getCheckedInputStream("entry");
        int n = this.data.length / 4;
        in.skip(n);
        in.read(new byte[n]);
        in.read(new byte[n], 0, n);
        while (in.read() != -1) {
        }
        in.close();
        zipIn.close();
    }

    @Test
    public final void testBadGetCheckedInputStream() throws IOException {
        if (ZipConstants.FORCE_ZIP64_EXT) {
            Assert.fail((String)"TODO: Adapt this test so that it works when ZIP64 extensions have been forced to use!");
        }
        for (int i = 0; i < 4; ++i) {
            InputStream in;
            String name = "entry";
            ZipOutputStream zipOut = new ZipOutputStream((OutputStream)new FileOutputStream(this.zip));
            zipOut.putNextEntry(new ZipEntry("entry"));
            zipOut.write(this.data);
            zipOut.close();
            boolean tweakDD = (i & 1) != 0;
            boolean tweakCFH = (i & 2) != 0;
            byte[] crc = new byte[]{-1, -1, -1, -1};
            RandomAccessFile raf = new RandomAccessFile(this.zip, "rw");
            if (tweakDD) {
                raf.seek(raf.length() - 57L - 28L);
                raf.write(crc);
            }
            if (tweakCFH) {
                raf.seek(raf.length() - 57L);
                raf.write(crc);
            }
            raf.close();
            ZipFile zipIn = new ZipFile(this.zip);
            try {
                in = zipIn.getCheckedInputStream("entry");
                if (tweakDD ^ tweakCFH) {
                    Assert.fail((String)"Expected CRC32Exception!");
                }
                in.close();
                if (tweakDD & tweakCFH) {
                    Assert.fail((String)"Expected CRC32Exception!");
                }
            }
            catch (CRC32Exception ex) {
                Assert.assertTrue((boolean)(tweakDD | tweakCFH));
            }
            try {
                in = zipIn.getCheckedInputStream("entry");
                if (tweakDD ^ tweakCFH) {
                    Assert.fail((String)"Expected CRC32Exception!");
                }
                int n = this.data.length / 4;
                in.skip(n);
                in.read(new byte[n]);
                in.read(new byte[n], 0, n);
                while (in.read() != -1) {
                }
                in.close();
                if (tweakDD & tweakCFH) {
                    Assert.fail((String)"Expected CRC32Exception!");
                }
            }
            catch (CRC32Exception ex) {
                Assert.assertTrue((boolean)(tweakDD | tweakCFH));
            }
            zipIn.close();
        }
    }

    static {
        String text = "This is a truly compressible text!\n";
        int count = 1024 / "This is a truly compressible text!\n".length();
        int length = count * "This is a truly compressible text!\n".length();
        StringBuilder buf = new StringBuilder(length);
        for (int i = 0; i < count; ++i) {
            buf.append("This is a truly compressible text!\n");
        }
        DATA = buf.toString().getBytes();
    }
}

