/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.archive.zip.ZipArchiveEntry;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.fs.archive.zip.ZipInputShop;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.io.OutputBusyException;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputShop;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.JointIterator;
import de.schlichtherle.truezip.zip.RawZipOutputStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

@DefaultAnnotation(value={NonNull.class})
public final class ZipOutputShop
extends RawZipOutputStream<ZipArchiveEntry>
implements OutputShop<ZipArchiveEntry> {
    private final IOPool<?> pool;
    @CheckForNull
    private IOPool.Entry<?> postamble;
    @Nullable
    private ZipArchiveEntry tempEntry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipOutputShop(ZipDriver driver, OutputStream out, @CheckForNull ZipInputShop source) throws IOException {
        super(out, null != source && source.isAppendee() ? source : null, driver.getCharset());
        super.setMethod(driver.getMethod());
        super.setLevel(driver.getLevel());
        this.pool = driver.getPool();
        if (null != source) {
            if (!source.isAppendee()) {
                super.setComment(source.getComment());
                if (0L < source.getPreambleLength()) {
                    InputStream in = source.getPreambleInputStream();
                    try {
                        Streams.cat((InputStream)in, (OutputStream)(source.offsetsConsiderPreamble() ? this : out));
                    }
                    finally {
                        in.close();
                    }
                }
            }
            if (0L < source.getPostambleLength()) {
                this.postamble = (IOPool.Entry)this.pool.allocate();
                Streams.copy((InputStream)source.getPostambleInputStream(), (OutputStream)this.postamble.getOutputSocket().newOutputStream());
            }
        }
    }

    public int getSize() {
        return super.size() + (null != this.tempEntry ? 1 : 0);
    }

    @Override
    public Iterator<ZipArchiveEntry> iterator() {
        if (null == this.tempEntry) {
            return super.iterator();
        }
        return new JointIterator(super.iterator(), Collections.singletonList(this.tempEntry).iterator());
    }

    @Override
    @CheckForNull
    public ZipArchiveEntry getEntry(String name) {
        ZipArchiveEntry entry = (ZipArchiveEntry)super.getEntry(name);
        if (null != entry) {
            return entry;
        }
        entry = this.tempEntry;
        return null != entry && name.equals(entry.getName()) ? entry : null;
    }

    public OutputSocket<ZipArchiveEntry> getOutputSocket(final ZipArchiveEntry entry) {
        if (null == entry) {
            throw new NullPointerException();
        }
        class Output
        extends OutputSocket<ZipArchiveEntry> {
            Output() {
            }

            public ZipArchiveEntry getLocalTarget() {
                return entry;
            }

            public OutputStream newOutputStream() throws IOException {
                long size;
                if (ZipOutputShop.this.isBusy()) {
                    throw new OutputBusyException(entry.getName());
                }
                if (entry.isDirectory()) {
                    entry.setMethod(0);
                    entry.setCrc(0L);
                    entry.setCompressedSize(0L);
                    entry.setSize(0L);
                    return new EntryOutputStream(entry);
                }
                Entry peer = this.getPeerTarget();
                if (null != peer && -1L != (size = peer.getSize(Entry.Size.DATA))) {
                    entry.setSize(size);
                    if (peer instanceof ZipArchiveEntry) {
                        ZipArchiveEntry zipPeer = (ZipArchiveEntry)peer;
                        if (entry.getMethod() == -1) {
                            entry.setMethod(zipPeer.getMethod());
                        }
                        if (entry.getMethod() == zipPeer.getMethod()) {
                            entry.setCompressedSize(zipPeer.getCompressedSize());
                        }
                        entry.setCrc(zipPeer.getCrc());
                        return new EntryOutputStream(entry, zipPeer.getMethod() != 8);
                    }
                }
                switch (entry.getMethod()) {
                    case -1: {
                        entry.setMethod(8);
                        break;
                    }
                    case 0: {
                        if (-1L != entry.getCrc() && -1L != entry.getCompressedSize() && -1L != entry.getSize()) break;
                        return new BufferedEntryOutputStream((IOPool.Entry)ZipOutputShop.this.pool.allocate(), entry);
                    }
                    case 8: {
                        break;
                    }
                    default: {
                        assert (false) : "unsupported method";
                        break;
                    }
                }
                return new EntryOutputStream(entry);
            }
        }
        return new Output();
    }

    @Override
    public final boolean isBusy() {
        return super.isBusy() || null != this.tempEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block10: {
            try {
                IOPool.Entry<?> postamble = this.postamble;
                if (null == postamble) break block10;
                this.postamble = null;
                try {
                    InputSocket input = postamble.getInputSocket();
                    InputStream in = input.newInputStream();
                    try {
                        long ol = this.length();
                        long ipl = ((Entry)input.getLocalTarget()).getSize(Entry.Size.DATA);
                        if ((ol + ipl) % 4L != 0L) {
                            this.write(new byte[4 - (int)(ol % 4L)]);
                        }
                        Streams.cat((InputStream)in, (OutputStream)((Object)this));
                    }
                    finally {
                        in.close();
                    }
                }
                finally {
                    postamble.release();
                }
            }
            finally {
                super.close();
            }
        }
    }

    private class BufferedEntryOutputStream
    extends CheckedOutputStream {
        private final IOPool.Entry<?> temp;
        private boolean closed;

        BufferedEntryOutputStream(IOPool.Entry<?> temp, ZipArchiveEntry entry) throws IOException {
            super(temp.getOutputSocket().newOutputStream(), new CRC32());
            assert (0 == entry.getMethod());
            this.temp = temp;
            ZipOutputShop.this.tempEntry = entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                try {
                    super.close();
                }
                finally {
                    long length = this.temp.getSize(Entry.Size.DATA);
                    if (length > Integer.MAX_VALUE) {
                        throw new IOException("file too large");
                    }
                    ZipOutputShop.this.tempEntry.setCrc(this.getChecksum().getValue());
                    ZipOutputShop.this.tempEntry.setCompressedSize(length);
                    ZipOutputShop.this.tempEntry.setSize(length);
                    this.store();
                }
            }
            finally {
                ZipOutputShop.this.tempEntry = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void store() throws IOException {
            try {
                InputStream in = this.temp.getInputSocket().newInputStream();
                try {
                    ZipOutputShop.this.putNextEntry(ZipOutputShop.this.tempEntry);
                    try {
                        Streams.cat((InputStream)in, (OutputStream)((Object)ZipOutputShop.this));
                    }
                    finally {
                        ZipOutputShop.this.closeEntry();
                    }
                }
                finally {
                    in.close();
                }
            }
            finally {
                this.temp.release();
            }
        }
    }

    private class EntryOutputStream
    extends DecoratingOutputStream {
        EntryOutputStream(ZipArchiveEntry entry) throws IOException {
            this(entry, true);
        }

        EntryOutputStream(ZipArchiveEntry entry, boolean deflate) throws IOException {
            super((OutputStream)((Object)ZipOutputShop.this));
            ZipOutputShop.this.putNextEntry(entry, deflate);
        }

        public void close() throws IOException {
            ZipOutputShop.this.closeEntry();
        }
    }
}

