/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.ExtraField;
import de.schlichtherle.truezip.zip.UShort;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class DefaultExtraField
extends ExtraField {
    private final int headerID;
    @CheckForNull
    private byte[] data;

    DefaultExtraField(int headerID) {
        UShort.check(headerID, "Header ID out of range", null);
        this.headerID = headerID;
    }

    @Override
    int getHeaderID() {
        return this.headerID;
    }

    @Override
    int getDataSize() {
        byte[] data = this.data;
        return null != data ? data.length : 0;
    }

    @Override
    void readFrom(byte[] src, int off, int size) {
        UShort.check(size, "Data Size out of range", null);
        this.data = new byte[size];
        byte[] dst = this.data;
        System.arraycopy(src, off, dst, 0, size);
    }

    @Override
    void writeTo(byte[] dst, int off) {
        byte[] src = this.data;
        if (null != src) {
            System.arraycopy(src, 0, dst, off, src.length);
        }
    }
}

