/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.ExtraField;
import de.schlichtherle.truezip.zip.LittleEndian;
import de.schlichtherle.truezip.zip.UShort;
import de.schlichtherle.truezip.zip.ZipConstants;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.TreeMap;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class ExtraFields
implements Cloneable {
    private Map<Integer, ExtraField> extra = new TreeMap<Integer, ExtraField>();

    ExtraFields() {
    }

    public ExtraFields clone() {
        try {
            ExtraFields clone = (ExtraFields)super.clone();
            clone.extra = new TreeMap<Integer, ExtraField>(this.extra);
            return clone;
        }
        catch (CloneNotSupportedException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
    }

    int size() {
        return this.extra.size();
    }

    @Nullable
    ExtraField get(int headerID) {
        UShort.check(headerID);
        ExtraField ef = this.extra.get(headerID);
        assert (null == ef || ef.getHeaderID() == headerID);
        return ef;
    }

    ExtraField put(ExtraField ef) {
        if (null == ef) {
            throw new NullPointerException();
        }
        int headerID = ef.getHeaderID();
        UShort.check(headerID);
        return this.extra.put(headerID, ef);
    }

    @Nullable
    ExtraField remove(int headerID) {
        UShort.check(headerID);
        ExtraField ef = this.extra.remove(headerID);
        assert (null == ef || ef.getHeaderID() == headerID);
        return ef;
    }

    int getExtraLength() {
        if (this.extra.isEmpty()) {
            return 0;
        }
        int l = 0;
        for (ExtraField ef : this.extra.values()) {
            l += 4 + ef.getDataSize();
        }
        return l;
    }

    byte[] getExtra() {
        int size = this.getExtraLength();
        UShort.check(size);
        if (0 == size) {
            return ZipConstants.EMPTY;
        }
        byte[] data = new byte[size];
        this.writeTo(data, 0);
        return data;
    }

    void readFrom(byte[] data, int off, int size) {
        UShort.check(size, "Extra Field out of range", null);
        TreeMap<Integer, ExtraField> map = new TreeMap<Integer, ExtraField>();
        if (null != data && 0 < size) {
            int end = off + size;
            while (off < end) {
                int headerID = LittleEndian.readUShort(data, off);
                int dataSize = LittleEndian.readUShort(data, off += 2);
                ExtraField ef = ExtraField.create(headerID);
                ef.readFrom(data, off += 2, dataSize);
                off += dataSize;
                map.put(headerID, ef);
            }
            assert (off == end);
        }
        this.extra = map;
    }

    void writeTo(byte[] data, int off) {
        for (ExtraField ef : this.extra.values()) {
            LittleEndian.writeShort(ef.getHeaderID(), data, off);
            LittleEndian.writeShort(ef.getDataSize(), data, off += 2);
            ef.writeTo(data, off += 2);
            off += ef.getDataSize();
        }
    }
}

