/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe.swing;

import de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import de.schlichtherle.truezip.crypto.param.KeyStrength;
import de.schlichtherle.truezip.key.pbe.swing.JemmyUtils;
import de.schlichtherle.truezip.key.pbe.swing.KeyStrengthPanel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JFrameOperator;

public final class KeyStrengthPanelTest
extends JemmyUtils {
    private KeyStrengthPanel<AesKeyStrength> panel;
    private JFrameOperator frame;

    @Before
    public void setUp() {
        this.panel = new KeyStrengthPanel((KeyStrength[])AesKeyStrength.values());
        this.frame = KeyStrengthPanelTest.showInNewFrame(this.panel);
    }

    @After
    public void tearDown() throws Exception {
        this.frame.dispose();
    }

    @Test
    public void testKeyStrength() throws Exception {
        JComboBoxOperator comboBox = new JComboBoxOperator((ContainerOperator)this.frame);
        AesKeyStrength expResult = AesKeyStrength.BITS_128;
        AesKeyStrength keyStrength = (AesKeyStrength)this.panel.getKeyStrength();
        Assert.assertSame((Object)expResult, (Object)keyStrength);
        int selection = comboBox.getSelectedIndex();
        Assert.assertSame((Object)expResult.ordinal(), (Object)selection);
        expResult = AesKeyStrength.BITS_128;
        this.panel.setKeyStrength((KeyStrength)expResult);
        keyStrength = (AesKeyStrength)this.panel.getKeyStrength();
        Assert.assertSame((Object)expResult, (Object)keyStrength);
        selection = comboBox.getSelectedIndex();
        Assert.assertSame((Object)expResult.ordinal(), (Object)selection);
        expResult = AesKeyStrength.BITS_192;
        this.panel.setKeyStrength((KeyStrength)expResult);
        keyStrength = (AesKeyStrength)this.panel.getKeyStrength();
        Assert.assertSame((Object)expResult, (Object)keyStrength);
        selection = comboBox.getSelectedIndex();
        Assert.assertSame((Object)expResult.ordinal(), (Object)selection);
        expResult = AesKeyStrength.BITS_256;
        this.panel.setKeyStrength((KeyStrength)expResult);
        keyStrength = (AesKeyStrength)this.panel.getKeyStrength();
        Assert.assertSame((Object)expResult, (Object)keyStrength);
        selection = comboBox.getSelectedIndex();
        Assert.assertSame((Object)expResult.ordinal(), (Object)selection);
        try {
            this.panel.setKeyStrength(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        keyStrength = (AesKeyStrength)this.panel.getKeyStrength();
        Assert.assertSame((Object)expResult, (Object)keyStrength);
        selection = comboBox.getSelectedIndex();
        Assert.assertSame((Object)expResult.ordinal(), (Object)selection);
        expResult = AesKeyStrength.BITS_128;
        comboBox.setSelectedIndex(expResult.ordinal());
        keyStrength = (AesKeyStrength)this.panel.getKeyStrength();
        Assert.assertSame((Object)expResult, (Object)keyStrength);
        selection = comboBox.getSelectedIndex();
        Assert.assertSame((Object)expResult.ordinal(), (Object)selection);
        expResult = AesKeyStrength.BITS_192;
        comboBox.setSelectedIndex(expResult.ordinal());
        keyStrength = (AesKeyStrength)this.panel.getKeyStrength();
        Assert.assertSame((Object)expResult, (Object)keyStrength);
        selection = comboBox.getSelectedIndex();
        Assert.assertSame((Object)expResult.ordinal(), (Object)selection);
        expResult = AesKeyStrength.BITS_256;
        comboBox.setSelectedIndex(expResult.ordinal());
        keyStrength = (AesKeyStrength)this.panel.getKeyStrength();
        Assert.assertSame((Object)expResult, (Object)keyStrength);
        selection = comboBox.getSelectedIndex();
        Assert.assertSame((Object)expResult.ordinal(), (Object)selection);
    }
}

