/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyPromptingCancelledException;
import de.schlichtherle.truezip.key.PromptingKeyProvider;
import de.schlichtherle.truezip.key.SafeKey;
import de.schlichtherle.truezip.key.UnknownKeyException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.URI;
import java.util.Random;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public final class MockView<K extends SafeKey<K>>
implements PromptingKeyProvider.View<K> {
    @CheckForNull
    private volatile URI resource;
    @CheckForNull
    private volatile K key;
    private volatile Action action = Action.ENTER;
    private volatile boolean changeRequested;

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        if (null == action) {
            throw new NullPointerException();
        }
        this.action = action;
    }

    @CheckForNull
    public URI getResource() {
        return this.resource;
    }

    public void setResource(@CheckForNull URI resource) {
        this.resource = resource;
    }

    @CheckForNull
    public K getKey() {
        return this.key;
    }

    public void setKey(@CheckForNull K key) {
        this.key = key;
    }

    public boolean isChangeRequested() {
        return this.changeRequested;
    }

    public void setChangeRequested(boolean changeRequested) {
        this.changeRequested = changeRequested;
    }

    public synchronized void promptWriteKey(PromptingKeyProvider.Controller<K> controller) throws UnknownKeyException {
        URI resource = this.getResource();
        if (null != resource && !resource.equals(controller.getResource())) {
            throw new IllegalArgumentException();
        }
        controller.getKey();
        try {
            controller.setChangeRequested(true);
            throw new IllegalArgumentException();
        }
        catch (IllegalStateException expected) {
            try {
                controller.setChangeRequested(false);
                throw new IllegalArgumentException();
            }
            catch (IllegalStateException illegalStateException) {
                this.action.promptWriteKey(controller, this.key);
                return;
            }
        }
    }

    public synchronized void promptReadKey(PromptingKeyProvider.Controller<K> controller, boolean invalid) throws UnknownKeyException {
        URI resource = this.getResource();
        if (null != resource && !resource.equals(controller.getResource())) {
            throw new IllegalArgumentException();
        }
        try {
            controller.getKey();
            throw new IllegalArgumentException();
        }
        catch (IllegalStateException expected) {
            this.action.promptReadKey(controller, this.key, this.changeRequested);
            return;
        }
    }

    public static enum Action {
        ENTER{

            @Override
            <K extends SafeKey<K>> void promptWriteKey(PromptingKeyProvider.Controller<? super K> controller, K key) throws UnknownKeyException {
                controller.setKey(null);
                controller.setKey(null != key ? (SafeKey)key.clone() : null);
            }

            @Override
            <K extends SafeKey<K>> void promptReadKey(PromptingKeyProvider.Controller<? super K> controller, K key, boolean changeRequested) throws UnknownKeyException {
                controller.setKey(null);
                controller.setChangeRequested(false);
                controller.setChangeRequested(true);
                controller.setKey(null != key ? (SafeKey)key.clone() : null);
                controller.setChangeRequested(changeRequested);
            }
        }
        ,
        CANCEL{
            private final Random rnd = new Random();

            @Override
            <K extends SafeKey<K>> void promptWriteKey(PromptingKeyProvider.Controller<? super K> controller, K key) throws UnknownKeyException {
                if (this.rnd.nextBoolean()) {
                    throw new KeyPromptingCancelledException();
                }
                controller.setKey(null);
            }

            @Override
            <K extends SafeKey<K>> void promptReadKey(PromptingKeyProvider.Controller<? super K> controller, K key, boolean changeRequested) throws UnknownKeyException {
                if (this.rnd.nextBoolean()) {
                    throw new KeyPromptingCancelledException();
                }
                controller.setChangeRequested(false);
                controller.setKey(null);
                controller.setChangeRequested(true);
            }
        }
        ,
        IGNORE{

            @Override
            <K extends SafeKey<K>> void promptWriteKey(PromptingKeyProvider.Controller<? super K> controller, K key) throws UnknownKeyException {
            }

            @Override
            <K extends SafeKey<K>> void promptReadKey(PromptingKeyProvider.Controller<? super K> controller, K key, boolean changeRequested) throws UnknownKeyException {
            }
        };


        abstract <K extends SafeKey<K>> void promptWriteKey(PromptingKeyProvider.Controller<? super K> var1, @CheckForNull K var2) throws UnknownKeyException;

        abstract <K extends SafeKey<K>> void promptReadKey(PromptingKeyProvider.Controller<? super K> var1, @CheckForNull K var2, boolean var3) throws UnknownKeyException;
    }
}

