/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe.swing;

import de.schlichtherle.truezip.key.pbe.SafePbeParameters;
import de.schlichtherle.truezip.key.pbe.swing.FileChooserOperator;
import de.schlichtherle.truezip.key.pbe.swing.JemmyUtils;
import de.schlichtherle.truezip.key.pbe.swing.KeyPanel;
import java.io.File;
import java.net.URI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.util.NameComponentChooser;

public abstract class KeyPanelTestSuite<P extends KeyPanel>
extends JemmyUtils {
    private static final ComponentChooser KEY_FILE_CHOOSER = new NameComponentChooser("keyFileChooser");
    protected P panel;
    protected JFrameOperator frame;
    protected JLabelOperator error;

    @Before
    public void setUp() throws Exception {
        this.panel = this.newKeyPanel();
        this.frame = KeyPanelTestSuite.showInNewFrame(this.panel);
        this.error = this.findErrorLabel(this.frame);
    }

    protected abstract P newKeyPanel();

    protected abstract SafePbeParameters<?, ?> newPbeParameters();

    private JLabelOperator findErrorLabel(JFrameOperator frame) {
        String error = "error";
        this.panel.setError("error");
        JLabelOperator errorLabel = new JLabelOperator((ContainerOperator)frame, "error");
        frame.pack();
        new QueueTool().waitEmpty();
        this.panel.setError(null);
        return errorLabel;
    }

    @After
    public void tearDown() throws Exception {
        this.frame.dispose();
    }

    @Test
    public void testResource() {
        URI id = URI.create("HelloWorld!");
        this.panel.setResource(id);
        Assert.assertEquals((Object)id, (Object)this.panel.getResource());
        new JTextComponentOperator((ContainerOperator)this.frame, id.toString());
    }

    @Test
    public void testError() {
        this.panel.setError("This is a test error message!");
        Assert.assertFalse((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
        new JTextFieldOperator((ContainerOperator)this.frame).typeText("secret");
        new QueueTool().waitEmpty();
        Assert.assertTrue((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
        this.panel.setError("This is a test error message!");
        Assert.assertFalse((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
        new JTabbedPaneOperator((ContainerOperator)this.frame).selectPage(1);
        new JButtonOperator((ContainerOperator)this.frame, KEY_FILE_CHOOSER).push();
        new FileChooserOperator().chooseFile("file");
        new QueueTool().waitEmpty();
        Assert.assertTrue((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
    }

    protected static boolean isBlank(String s) {
        return null == s || s.trim().length() <= 0;
    }

    @Test
    public void testKeyFile() {
        SafePbeParameters<?, ?> param = this.newPbeParameters();
        new JTabbedPaneOperator((ContainerOperator)this.frame).selectPage(1);
        new JButtonOperator((ContainerOperator)this.frame, KEY_FILE_CHOOSER).push();
        new FileChooserOperator().chooseFile("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!\"$%&/()=?");
        new QueueTool().waitEmpty();
        Assert.assertTrue((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
        Assert.assertFalse((boolean)this.panel.updateParam(param));
        Assert.assertNotNull((Object)this.error.getText());
        new JButtonOperator((ContainerOperator)this.frame, KEY_FILE_CHOOSER).push();
        FileChooserOperator fc = new FileChooserOperator();
        File[] files = fc.getFiles();
        fc.cancel();
        for (File file : files) {
            if (!file.isFile()) continue;
            new JButtonOperator((ContainerOperator)this.frame, KEY_FILE_CHOOSER).push();
            fc = new FileChooserOperator();
            fc.setSelectedFile(file);
            fc.approve();
            new QueueTool().waitEmpty();
            if (this.panel.updateParam(param)) {
                Assert.assertNotNull((Object)param.getPassword());
                Assert.assertTrue((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
                continue;
            }
            Assert.assertFalse((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
        }
    }
}

