/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.zip.WinZipAesParameters;
import de.schlichtherle.truezip.zip.ZipCryptoParameters;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import de.schlichtherle.truezip.zip.ZipKeyException;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import de.schlichtherle.truezip.zip.ZipTestSuite;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipException;
import org.junit.Assert;

public final class WinZipAesTest
extends ZipTestSuite {
    @Override
    public ZipEntry newEntry(String name) {
        ZipEntry entry = new ZipEntry(name);
        entry.setEncrypted(true);
        return entry;
    }

    @Override
    protected ZipOutputStream newZipOutputStream(OutputStream out) throws IOException {
        ZipOutputStream res = new ZipOutputStream(out);
        res.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return res;
    }

    @Override
    protected ZipOutputStream newZipOutputStream(OutputStream out, Charset charset) throws IOException {
        ZipOutputStream res = new ZipOutputStream(out, charset);
        res.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return res;
    }

    @Override
    protected ZipOutputStream newZipOutputStream(OutputStream out, ZipFile appendee) throws ZipException {
        ZipOutputStream res = new ZipOutputStream(out, appendee);
        res.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return res;
    }

    @Override
    protected ZipFile newZipFile(String name) throws IOException {
        ZipFile res = new ZipFile(name);
        res.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return res;
    }

    @Override
    protected ZipFile newZipFile(String name, Charset charset) throws IOException {
        ZipFile res = new ZipFile(name, charset);
        res.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return res;
    }

    @Override
    protected ZipFile newZipFile(File file) throws IOException {
        ZipFile res = new ZipFile(file);
        res.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return res;
    }

    @Override
    protected ZipFile newZipFile(File file, Charset charset) throws IOException {
        ZipFile res = new ZipFile(file, charset);
        res.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return res;
    }

    @Override
    protected ZipFile newZipFile(ReadOnlyFile file) throws IOException {
        ZipFile res = new ZipFile(file);
        res.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return res;
    }

    @Override
    protected ZipFile newZipFile(ReadOnlyFile file, Charset charset) throws IOException {
        ZipFile res = new ZipFile(file, charset);
        res.setCryptoParameters((ZipCryptoParameters)new WinZipAesCryptoParameters());
        return res;
    }

    @Override
    @Deprecated
    public void testBadGetCheckedInputStream() {
    }

    private static final class WinZipAesCryptoParameters
    implements WinZipAesParameters {
        private WinZipAesCryptoParameters() {
        }

        public byte[] getWritePassword(String name) throws ZipKeyException {
            return "secret".getBytes();
        }

        public byte[] getReadPassword(String name, boolean invalid) throws ZipKeyException {
            return "secret".getBytes();
        }

        public AesKeyStrength getKeyStrength(String name) throws ZipKeyException {
            return AesKeyStrength.BITS_128;
        }

        public void setKeyStrength(String name, AesKeyStrength keyStrength) throws ZipKeyException {
            Assert.assertSame((Object)AesKeyStrength.BITS_128, (Object)keyStrength);
        }
    }
}

