/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip.sample;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.archive.zip.sample.KeyManagement;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@Deprecated
public class KeyManagementTest {
    private static final Logger logger = Logger.getLogger(KeyManagementTest.class.getName());
    private static final String PREFIX = "tzp";
    private static final String SUFFIX = "eaff";
    private static final String PASSWORD = "secret";
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private static final Random rnd = new Random();
    private static final byte[] DATA = new byte[1024];
    private File temp;
    private byte[] data;

    @Before
    public void setUp() throws IOException {
        TFile.umount();
        this.temp = KeyManagementTest.createTempFile();
        Assert.assertTrue((boolean)this.temp.delete());
        this.data = (byte[])DATA.clone();
    }

    private static File createTempFile() throws IOException {
        return File.createTempFile(PREFIX, ".eaff").getCanonicalFile();
    }

    @After
    public void tearDown() {
        try {
            TFile.umount();
        }
        catch (FsSyncException ex) {
            logger.log(Level.WARNING, ex.toString(), ex);
        }
        if (this.temp.exists() && !this.temp.delete()) {
            logger.log(Level.WARNING, "{0} (could not delete)", this.temp);
        }
    }

    @Test
    public void testSetPasswords1() throws IOException {
        TArchiveDetector detector = KeyManagement.newArchiveDetector1((FsDriverProvider)TFile.getDefaultArchiveDetector(), SUFFIX, PASSWORD.getBytes(US_ASCII));
        KeyManagementTest.roundTripTest(new TFile(this.temp, detector), this.data);
    }

    @Test
    public void testSetPasswords2() throws IOException {
        TArchiveDetector detector = KeyManagement.newArchiveDetector2((FsDriverProvider)TFile.getDefaultArchiveDetector(), SUFFIX, PASSWORD.toCharArray());
        KeyManagementTest.roundTripTest(new TFile(this.temp, detector), this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void roundTripTest(TFile archive, byte[] data) throws IOException {
        TFile file = new TFile((File)archive, "entry");
        Object out = new TFileOutputStream((File)file);
        try {
            out.write(data);
        }
        finally {
            out.close();
        }
        out = new ByteArrayOutputStream(data.length);
        TFileInputStream in = new TFileInputStream((File)file);
        try {
            TFile.cat((InputStream)in, (OutputStream)out);
        }
        finally {
            in.close();
        }
        Arrays.equals(data, ((ByteArrayOutputStream)out).toByteArray());
    }

    static {
        rnd.nextBytes(DATA);
    }
}

