/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.DefaultExtraField;
import de.schlichtherle.truezip.zip.ExtraField;
import de.schlichtherle.truezip.zip.ExtraFields;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ExtraFieldsTest {
    private final byte[] SERIALIZED = new byte[]{0, 0, 0, 0, 1, 0, 28, 0, 33, 67, 101, -121, -87, -53, -19, 15, 33, 67, 101, -121, -87, -53, -19, 15, 33, 67, 101, -121, -87, -53, -19, 15, 33, 67, 101, -121, -2, -54, 0, 0};
    private ExtraFields fields;
    private byte[] serialized;

    @Before
    public void setUp() {
        this.fields = new ExtraFields();
        this.serialized = (byte[])this.SERIALIZED.clone();
    }

    @Test
    public void testGetSet() {
        Assert.assertEquals((long)0L, (long)this.fields.getExtra().length);
        this.fields.readFrom(this.serialized, 0, this.serialized.length);
        Assert.assertEquals((long)this.serialized.length, (long)this.fields.getExtraLength());
        this.serialized[0] = -1;
        byte[] got1 = this.fields.getExtra();
        Assert.assertNotNull((Object)got1);
        Assert.assertNotSame((Object)this.serialized, (Object)got1);
        byte[] got2 = this.fields.getExtra();
        Assert.assertNotNull((Object)got2);
        Assert.assertNotSame((Object)this.serialized, (Object)got2);
        Assert.assertNotSame((Object)got1, (Object)got2);
        this.serialized[0] = 0;
        Assert.assertTrue((boolean)Arrays.equals(this.serialized, got1));
        Assert.assertTrue((boolean)Arrays.equals(this.serialized, got2));
    }

    @Test
    public void testCollection0() {
        this.fields.readFrom(this.serialized, 0, this.serialized.length);
        ExtraField ef = this.fields.get(1);
        Assert.assertNotNull((Object)ef);
        Assert.assertSame((Object)ef, (Object)this.fields.remove(1));
        Assert.assertNull((Object)this.fields.get(1));
        Assert.assertNull((Object)this.fields.add(ef));
        byte[] got = this.fields.getExtra();
        Assert.assertNotSame((Object)this.serialized, (Object)got);
        Assert.assertTrue((boolean)Arrays.equals(this.serialized, got));
    }

    @Test
    public void testCollection1() {
        Assert.assertEquals((long)0L, (long)this.fields.getExtra().length);
        DefaultExtraField ef = new DefaultExtraField(1);
        Assert.assertNull((Object)this.fields.get(1));
        Assert.assertNull((Object)this.fields.add((ExtraField)ef));
        byte[] got = this.fields.getExtra();
        Assert.assertEquals((long)(4 + ef.getDataSize()), (long)got.length);
        Assert.assertSame((Object)ef, (Object)this.fields.remove(1));
        Assert.assertEquals((long)0L, (long)this.fields.getExtra().length);
    }
}

