/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.DateTimeConverter;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class DateTimeConverterTestSuite {
    private DateTimeConverter instance;
    private long minJavaTime;
    private long maxJavaTime;

    @Before
    public void setUp() {
        this.instance = this.getInstance();
        GregorianCalendar calendar = new GregorianCalendar(this.instance.newTimeZone());
        calendar.set(14, 0);
        calendar.set(1980, 0, 1, 0, 0, 0);
        this.minJavaTime = calendar.getTimeInMillis();
        calendar.set(2107, 11, 31, 23, 59, 58);
        this.maxJavaTime = calendar.getTimeInMillis();
    }

    abstract DateTimeConverter getInstance();

    @Test
    public final void testNewTimeZone() {
        TimeZone tz1 = this.instance.newTimeZone();
        Assert.assertNotNull((Object)tz1);
        TimeZone tz2 = this.instance.newTimeZone();
        Assert.assertNotNull((Object)tz1);
        Assert.assertNotSame((Object)tz1, (Object)tz2);
        Assert.assertTrue((boolean)tz1.hasSameRules(tz2));
    }

    @Test
    public final void testToJavaTime() {
        Assert.assertThat((Object)this.instance.toJavaTime(Long.MIN_VALUE), (Matcher)CoreMatchers.is((Object)this.minJavaTime));
        Assert.assertThat((Object)this.instance.toJavaTime(0x20FFFFL), (Matcher)CoreMatchers.is((Object)this.minJavaTime));
        Assert.assertThat((Object)this.instance.toJavaTime(0x210000L), (Matcher)CoreMatchers.is((Object)this.minJavaTime));
        Assert.assertThat((Object)this.instance.toJavaTime(4288659325L), (Matcher)CoreMatchers.is((Object)this.maxJavaTime));
        Assert.assertThat((Object)this.instance.toJavaTime(4288659326L), (Matcher)CoreMatchers.is((Object)this.maxJavaTime));
        Assert.assertThat((Object)this.instance.toJavaTime(Long.MAX_VALUE), (Matcher)CoreMatchers.is((Object)this.maxJavaTime));
    }

    @Test
    public final void testToDosTime() {
        try {
            this.instance.toDosTime(Long.MIN_VALUE);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.instance.toDosTime(-1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertThat((Object)this.instance.toDosTime(0L), (Matcher)CoreMatchers.is((Object)0x210000L));
        Assert.assertThat((Object)this.instance.toDosTime(this.minJavaTime - 1L), (Matcher)CoreMatchers.is((Object)0x210000L));
        Assert.assertThat((Object)this.instance.toDosTime(this.minJavaTime), (Matcher)CoreMatchers.is((Object)0x210000L));
        Assert.assertThat((Object)this.instance.toDosTime(this.maxJavaTime), (Matcher)CoreMatchers.is((Object)4288659325L));
        Assert.assertThat((Object)this.instance.toDosTime(this.maxJavaTime + 1L), (Matcher)CoreMatchers.is((Object)4288659325L));
        Assert.assertThat((Object)this.instance.toDosTime(Long.MAX_VALUE), (Matcher)CoreMatchers.is((Object)4288659325L));
    }

    @Test
    public void testRoundTripConversion() {
        for (long dTime : new long[]{0x210000L, 4288659325L}) {
            Assert.assertThat((Object)this.instance.toDosTime(this.instance.toJavaTime(dTime)), (Matcher)CoreMatchers.is((Object)dTime));
        }
    }

    @Test
    public void testGranularity() {
        long jTime = System.currentTimeMillis();
        long dTime = this.instance.toDosTime(jTime);
        Assert.assertThat((Object)this.instance.toDosTime(jTime - 2000L), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)dTime)));
        Assert.assertThat((Object)this.instance.toDosTime(jTime + 2000L), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)dTime)));
        Assert.assertThat((Object)this.instance.toJavaTime(this.instance.toDosTime(jTime - 2000L)), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)jTime)));
        Assert.assertThat((Object)this.instance.toJavaTime(this.instance.toDosTime(jTime + 2000L)), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.is((Object)jTime)));
    }
}

