/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.socket.ByteArrayIOBuffer;
import de.schlichtherle.truezip.util.ArrayHelper;
import de.schlichtherle.truezip.util.Maps;
import de.schlichtherle.truezip.zip.ZipEntry;
import de.schlichtherle.truezip.zip.ZipFile;
import de.schlichtherle.truezip.zip.ZipOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public final class ManySmallEntriesTest {
    private static final int FIRST_ENTRY = 100000;
    private static final int LAST_ENTRY = 169999;
    private static final int NUM_ENTRIES = 70000;
    private static final String DATA_STRING = "Hello World!";
    private static final Charset DATA_CHARSET = Charset.forName("US-ASCII");
    private static final int DATA_CRC = 472456355;
    private static final int ZIP_SIZE = 7000098;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManySmallEntries() throws IOException {
        ByteArrayIOBuffer buffer = new ByteArrayIOBuffer("zip", 7000098);
        byte[] data = DATA_STRING.getBytes(DATA_CHARSET);
        HashSet<String> set = new HashSet<String>(Maps.initialCapacity((int)70000));
        ZipOutputStream zipOut = new ZipOutputStream(buffer.getOutputSocket().newOutputStream());
        for (int i = 100000; i <= 169999; ++i) {
            String name = Integer.toString(i);
            ZipEntry entry = new ZipEntry(name);
            entry.setSize((long)data.length);
            entry.setCompressedSize((long)data.length);
            entry.setCrc(472456355L);
            entry.setMethod(0);
            zipOut.putNextEntry(entry);
            zipOut.write(data);
            Assert.assertTrue((boolean)set.add(name));
        }
        zipOut.close();
        Assert.assertEquals((long)7000098L, (long)buffer.getSize(Entry.Size.STORAGE));
        ZipFile zipIn = new ZipFile(buffer.getInputSocket().newReadOnlyFile());
        try {
            byte[] buf = new byte[data.length];
            Enumeration e = zipIn.entries();
            while (e.hasMoreElements()) {
                int read;
                ZipEntry entry = (ZipEntry)e.nextElement();
                Assert.assertEquals((long)data.length, (long)entry.getSize());
                InputStream in = zipIn.getCheckedInputStream(entry);
                int off = 0;
                while ((read = in.read(buf)) >= 0) {
                    Assert.assertTrue((read > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)ArrayHelper.equals((byte[])data, (int)off, (byte[])buf, (int)0, (int)read));
                    off += read;
                }
                Assert.assertEquals((long)-1L, (long)read);
                Assert.assertEquals((long)off, (long)data.length);
                Assert.assertEquals((long)0L, (long)in.read(new byte[0]));
                in.close();
                Assert.assertTrue((boolean)set.remove(entry.getName()));
            }
        }
        finally {
            zipIn.close();
        }
        Assert.assertTrue((boolean)set.isEmpty());
    }
}

