/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file.zip;

import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileITSuite;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.zip.TestWinZipAesDriver;
import de.schlichtherle.truezip.key.MockView;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public final class WinZipAesFileIT
extends TFileITSuite<TestWinZipAesDriver> {
    protected String getSuffixList() {
        return "zip";
    }

    protected TestWinZipAesDriver newArchiveDriver() {
        return new TestWinZipAesDriver(this.getTestConfig().getIOPoolProvider());
    }

    public void setUp() throws IOException {
        super.setUp();
        TConfig config = TConfig.get();
        config.setOutputPreferences(config.getOutputPreferences().set((Enum)FsOutputOption.ENCRYPT));
    }

    private void setAction(MockView.Action action) {
        ((TestWinZipAesDriver)this.getArchiveDriver()).getView().setAction(action);
    }

    @Test
    public void testCancelling() throws IOException {
        this.setAction(MockView.Action.CANCEL);
        TFile archive = this.getArchive();
        Assert.assertFalse((boolean)archive.toNonArchiveFile().exists());
        TFile entry1 = new TFile((File)archive, "entry1");
        Assert.assertTrue((boolean)entry1.mkdirs());
        entry1.rm();
        Assert.assertTrue((boolean)entry1.createNewFile());
        entry1.rm();
        TFile entry2 = new TFile((File)archive, "entry2");
        Assert.assertTrue((boolean)entry2.mkdirs());
        entry2.rm();
        Assert.assertTrue((boolean)entry2.createNewFile());
        entry2.rm();
    }

    @Test
    public void testFileStatus() throws IOException {
        TFile archive = this.getArchive();
        TFile inner = new TFile((File)archive, "inner" + this.getSuffix());
        Assert.assertTrue((boolean)archive.mkdir());
        Assert.assertTrue((boolean)inner.mkdir());
        this.umount();
        this.setAction(MockView.Action.CANCEL);
        Assert.assertTrue((boolean)archive.exists());
        Assert.assertTrue((boolean)archive.isDirectory());
        Assert.assertFalse((boolean)archive.isFile());
        this.umount();
        this.setAction(MockView.Action.ENTER);
        Assert.assertTrue((boolean)archive.exists());
        Assert.assertTrue((boolean)archive.isDirectory());
        Assert.assertFalse((boolean)archive.isFile());
        this.setAction(MockView.Action.CANCEL);
        Assert.assertTrue((boolean)inner.exists());
        Assert.assertFalse((boolean)inner.isDirectory());
        Assert.assertFalse((boolean)inner.isFile());
        this.umount();
        try {
            archive.rm_r();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.umount();
        this.setAction(MockView.Action.ENTER);
        archive.rm_r();
    }
}

