/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.Constants;
import de.schlichtherle.truezip.zip.DefaultExtraField;
import de.schlichtherle.truezip.zip.UShort;
import de.schlichtherle.truezip.zip.WinZipAesEntryExtraField;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
abstract class ExtraField {
    private static final Map<Integer, Class<? extends ExtraField>> registry = new HashMap<Integer, Class<? extends ExtraField>>();
    static final int ZIP64_HEADER_ID = 1;
    static final int WINZIP_AES_ID = 39169;

    ExtraField() {
    }

    static void register(Class<? extends ExtraField> c) {
        ExtraField ef;
        try {
            ef = c.newInstance();
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        int headerId = ef.getHeaderId();
        assert (UShort.check(headerId));
        registry.put(headerId, c);
    }

    static ExtraField create(int headerId) {
        ExtraField ef;
        assert (UShort.check(headerId));
        Class<? extends ExtraField> c = registry.get(headerId);
        try {
            ef = null != c ? c.newInstance() : new DefaultExtraField(headerId);
        }
        catch (Exception cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        assert (headerId == ef.getHeaderId());
        return ef;
    }

    abstract int getHeaderId();

    abstract int getDataSize();

    final byte[] getDataBlock() {
        int size = this.getDataSize();
        assert (UShort.check(size));
        if (0 == size) {
            return Constants.EMPTY;
        }
        byte[] data = new byte[size];
        this.writeTo(data, 0);
        return data;
    }

    abstract void readFrom(byte[] var1, int var2, int var3);

    abstract void writeTo(byte[] var1, int var2);

    static {
        ExtraField.register(WinZipAesEntryExtraField.class);
    }
}

