/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsCovariantEntry;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyProvider;
import de.schlichtherle.truezip.key.SafeKeyManager;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ControlFlowException;
import java.io.IOException;
import java.net.URI;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class KeyController<M extends FsModel, D extends ZipDriver>
extends FsDecoratingController<M, FsController<? extends M>> {
    private static final String ROOT_PATH = FsEntryName.ROOT.getPath();
    protected final D driver;
    private volatile KeyManager<?> manager;

    protected KeyController(FsController<? extends M> controller, D driver) {
        super(controller);
        if (null == driver) {
            throw new NullPointerException();
        }
        this.driver = driver;
    }

    protected abstract Class<?> getKeyType();

    protected abstract Class<? extends IOException> getKeyExceptionType();

    private KeyManager<?> getKeyManager() {
        KeyManager<?> manager = this.manager;
        return null != manager ? manager : (this.manager = ((ZipDriver)this.driver).getKeyManagerProvider().get(this.getKeyType()));
    }

    public FsEntry getEntry(FsEntryName name) throws IOException {
        try {
            return this.delegate.getEntry(name);
        }
        catch (ControlFlowException ex) {
            if (!name.isRoot() || null == this.findKeyException(ex)) {
                throw ex;
            }
            FsEntry entry = this.getParent().getEntry(this.getModel().getMountPoint().getPath().resolve(name).getEntryName());
            if (null == entry) {
                return null;
            }
            while (entry instanceof FsCovariantEntry) {
                entry = ((FsCovariantEntry)entry).getEntry();
            }
            FsCovariantEntry special = new FsCovariantEntry(ROOT_PATH);
            special.put(Entry.Type.SPECIAL, this.driver.newEntry(ROOT_PATH, Entry.Type.SPECIAL, (Entry)entry));
            return special;
        }
    }

    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        try {
            this.delegate.unlink(name, options);
        }
        catch (ControlFlowException ex) {
            IOException keyEx = this.findKeyException(ex);
            if (null == keyEx) {
                throw ex;
            }
            throw keyEx;
        }
        if (name.isRoot()) {
            this.getKeyManager().removeKeyProvider(((ZipDriver)this.driver).resourceUri(this.getModel(), name.toString()));
        }
    }

    @CheckForNull
    private IOException findKeyException(Throwable ex) {
        Class<IOException> clazz = this.getKeyExceptionType();
        do {
            if (!clazz.isInstance(ex)) continue;
            return clazz.cast(ex);
        } while (null != (ex = ex.getCause()));
        return null;
    }

    public void sync(BitField<FsSyncOption> options) throws FsSyncException {
        this.delegate.sync(options);
        KeyManager<?> manager = this.getKeyManager();
        URI resource = ((ZipDriver)this.driver).mountPointUri(this.getModel());
        KeyProvider<Object> provider = manager instanceof SafeKeyManager ? ((SafeKeyManager)manager).getMappedKeyProvider(resource) : manager.getKeyProvider(resource);
        if (null != provider) {
            ((ZipDriver)this.driver).getKeyProviderSyncStrategy().sync(provider);
        }
    }
}

