/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.zip.sample;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import de.schlichtherle.truezip.file.TVFS;
import de.schlichtherle.truezip.fs.FsSyncException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class KeyManagementTestSuite {
    private static final Logger logger = Logger.getLogger(KeyManagementTestSuite.class.getName());
    private static final String PREFIX = "tzp";
    private static final String SUFFIX = "eaff";
    private static final String PASSWORD = "secret";
    private static final byte[] DATA = new byte[1024];
    private byte[] data;
    private File temp;
    private TFile archive;

    @Before
    public void setUp() throws IOException {
        this.data = (byte[])DATA.clone();
        this.temp = KeyManagementTestSuite.createTempFile();
        Assert.assertTrue((boolean)this.temp.delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void tearDown() throws IOException {
        try {
            try {
                this.umount();
            }
            finally {
                File temp = this.temp;
                this.temp = null;
                if (null != temp && temp.exists() && !temp.delete()) {
                    throw new IOException(temp + " (could not delete)");
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.FINEST, "Failed to clean up test file (this may be just an aftermath):", ex);
        }
    }

    private static File createTempFile() throws IOException {
        return File.createTempFile(PREFIX, ".eaff").getCanonicalFile();
    }

    private void umount() throws FsSyncException {
        if (null != this.archive) {
            TVFS.umount((TFile)this.archive);
        }
    }

    @Test
    public void testSetPasswords1() throws IOException {
        this.archive = new TFile(this.temp, this.newArchiveDetector1(SUFFIX, PASSWORD));
        this.roundTrip();
    }

    protected abstract TArchiveDetector newArchiveDetector1(String var1, String var2);

    @Test
    public void testSetPasswords2() throws IOException {
        this.archive = new TFile(this.temp, this.newArchiveDetector2(SUFFIX, PASSWORD));
        this.roundTrip();
    }

    protected abstract TArchiveDetector newArchiveDetector2(String var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void roundTrip() throws IOException {
        TFile file = new TFile((File)this.archive, "entry");
        TFileOutputStream os = new TFileOutputStream((File)file);
        try {
            os.write(this.data);
        }
        finally {
            os.close();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.data.length);
        TFileInputStream is = new TFileInputStream((File)file);
        try {
            TFile.cat((InputStream)is, (OutputStream)baos);
        }
        finally {
            is.close();
        }
        Arrays.equals(this.data, baos.toByteArray());
    }

    static {
        new Random().nextBytes(DATA);
    }
}

