/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key;

import de.schlichtherle.truezip.key.KeyManager;
import de.schlichtherle.truezip.key.KeyProvider;
import java.net.URI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class KeyManagerTestSuite<M extends KeyManager<?>> {
    protected M manager;

    @Before
    public void setUp() {
        this.manager = this.newKeyManager();
    }

    protected abstract M newKeyManager();

    @Test
    public void testGetKeyProvider() {
        URI id = URI.create("a");
        try {
            this.manager.getKeyProvider(null);
            Assert.fail((String)"A NullPointerException is expected from the previous call!");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        KeyProvider prov1 = this.manager.getKeyProvider(id);
        Assert.assertNotNull((Object)prov1);
        KeyProvider prov2 = this.manager.getKeyProvider(id);
        Assert.assertSame((Object)prov1, (Object)prov2);
    }

    @Test
    public void testMoveKeyProvider() {
        URI idA = URI.create("a");
        URI idB = URI.create("b");
        try {
            this.manager.moveKeyProvider(null, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.manager.moveKeyProvider(idA, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.manager.moveKeyProvider(null, idB);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.manager.moveKeyProvider(idA, idB));
        KeyProvider provA1 = this.manager.getKeyProvider(idA);
        Assert.assertNotNull((Object)provA1);
        Assert.assertNull((Object)this.manager.moveKeyProvider(idA, idB));
        KeyProvider provA2 = this.manager.getKeyProvider(idA);
        Assert.assertNotNull((Object)provA2);
        Assert.assertFalse((boolean)provA1.equals(provA2));
        KeyProvider provB1 = this.manager.getKeyProvider(idB);
        Assert.assertNotNull((Object)provB1);
        Assert.assertSame((Object)provA1, (Object)provB1);
    }

    @Test
    public void testRemoveKeyProvider() {
        URI id = URI.create("a");
        Assert.assertNull((Object)this.manager.removeKeyProvider(id));
        KeyProvider prov1 = this.manager.getKeyProvider(id);
        Assert.assertNotNull((Object)this.manager.removeKeyProvider(id));
        Assert.assertNull((Object)this.manager.removeKeyProvider(id));
        KeyProvider prov2 = this.manager.getKeyProvider(id);
        Assert.assertNotNull((Object)this.manager.removeKeyProvider(id));
        Assert.assertNull((Object)this.manager.removeKeyProvider(id));
        Assert.assertFalse((boolean)prov1.equals(prov2));
    }
}

