/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.key.pbe.swing;

import de.schlichtherle.truezip.key.pbe.SafePbeParameters;
import de.schlichtherle.truezip.key.pbe.swing.KeyPanel;
import de.schlichtherle.truezip.key.pbe.swing.TFileChooserOperator;
import de.schlichtherle.truezip.swing.JemmyUtils;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JFrameOperator;
import org.netbeans.jemmy.operators.JLabelOperator;
import org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.jemmy.util.NameComponentChooser;

public abstract class KeyPanelTestSuite<P extends KeyPanel>
extends JemmyUtils {
    private static final ComponentChooser KEY_FILE_CHOOSER = new NameComponentChooser("keyFileChooser");
    private static final String NON_EXISTING_FILE = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    protected P panel;
    protected JFrameOperator frame;
    protected JLabelOperator error;

    @Before
    public void setUp() throws InterruptedException {
        this.panel = this.newKeyPanel();
        this.frame = KeyPanelTestSuite.showFrameWith(this.panel);
        String text = "error";
        this.panel.setError("error");
        this.error = new JLabelOperator((ContainerOperator)this.frame, "error");
        this.panel.setError(null);
    }

    protected abstract P newKeyPanel();

    protected abstract SafePbeParameters<?, ?> newPbeParameters();

    @After
    public void tearDown() {
        this.frame.dispose();
    }

    @Test
    public void testResource() {
        URI id = URI.create("HelloWorld!");
        this.panel.setResource(id);
        Assert.assertEquals((Object)id, (Object)this.panel.getResource());
        new JTextComponentOperator((ContainerOperator)this.frame, id.toString());
    }

    @Test
    public void testUpdateErrorLabel() {
        this.panel.setError("This is a test error message!");
        Assert.assertFalse((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
        JTextFieldOperator tf = new JTextFieldOperator((ContainerOperator)this.frame);
        tf.setText("secret");
        Assert.assertTrue((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
        this.panel.setError("This is a test error message!");
        Assert.assertFalse((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
        new JTabbedPaneOperator((ContainerOperator)this.frame).selectPage(1);
        new JButtonOperator((ContainerOperator)this.frame, KEY_FILE_CHOOSER).push();
        TFileChooserOperator fc = new TFileChooserOperator((WindowOperator)this.frame);
        fc.chooseFile(NON_EXISTING_FILE);
        fc.getQueueTool().waitEmpty(100L);
        Assert.assertTrue((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
    }

    protected static boolean isBlank(String s) {
        return null == s || s.trim().length() <= 0;
    }

    @Test
    public void testKeyFile() throws InterruptedException {
        SafePbeParameters<?, ?> param = this.newPbeParameters();
        new JTabbedPaneOperator((ContainerOperator)this.frame).selectPage(1);
        new JButtonOperator((ContainerOperator)this.frame, KEY_FILE_CHOOSER).push();
        TFileChooserOperator fc = new TFileChooserOperator((WindowOperator)this.frame);
        fc.chooseFile(NON_EXISTING_FILE);
        fc.getQueueTool().waitEmpty(100L);
        Assert.assertTrue((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
        Assert.assertFalse((boolean)this.updateParam(param));
        Assert.assertFalse((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
        new JButtonOperator((ContainerOperator)this.frame, KEY_FILE_CHOOSER).push();
        fc = new TFileChooserOperator((WindowOperator)this.frame);
        List<File> files = Arrays.asList(fc.getFiles());
        Collections.shuffle(files);
        for (File file : files) {
            if (!file.isFile()) continue;
            fc.setSelectedFile(file);
            fc.approve();
            if (this.updateParam(param)) {
                Assert.assertNotNull((Object)param.getPassword());
                Assert.assertTrue((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
            } else {
                Assert.assertFalse((boolean)KeyPanelTestSuite.isBlank(this.error.getText()));
            }
            return;
        }
        fc.cancel();
    }

    protected final boolean updateParam(final SafePbeParameters<?, ?> param) throws InterruptedException {
        class Update
        implements Runnable {
            boolean result;

            Update() {
            }

            @Override
            public void run() {
                this.result = KeyPanelTestSuite.this.panel.updateParam(param);
            }
        }
        Update update = new Update();
        try {
            EventQueue.invokeAndWait(update);
        }
        catch (InvocationTargetException ex) {
            throw new AssertionError((Object)ex);
        }
        return update.result;
    }
}

