/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.zip;

import de.schlichtherle.truezip.zip.DefaultExtraField;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class DefaultExtraFieldTest {
    private DefaultExtraField def;

    @Before
    public void setUp() {
        this.def = new DefaultExtraField(0);
    }

    @Test
    public void testConstructor() {
        try {
            this.def = new DefaultExtraField(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.def = new DefaultExtraField(65536);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.def = new DefaultExtraField(0);
        Assert.assertEquals((long)0L, (long)this.def.getHeaderId());
        Assert.assertEquals((long)0L, (long)this.def.getDataSize());
        this.def = new DefaultExtraField(65535);
        Assert.assertEquals((long)65535L, (long)this.def.getHeaderId());
        Assert.assertEquals((long)0L, (long)this.def.getDataSize());
    }

    @Test
    public void testGetDataSize() {
        Assert.assertEquals((long)0L, (long)this.def.getDataSize());
    }

    @Test
    public void testGetDataBlock() {
        Assert.assertEquals((long)0L, (long)this.def.getDataBlock().length);
    }

    @Test
    public void testReadWrite() {
        byte[] read = new byte[11];
        try {
            this.def.readFrom(read, 1, -1);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            this.def.readFrom(read, 1, read.length);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            this.def.readFrom(read, read.length, 1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException expected) {
            // empty catch block
        }
        try {
            this.def.readFrom(read, 1, 65536);
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        this.def.readFrom(read, 1, read.length - 1);
        Assert.assertEquals((long)(read.length - 1), (long)this.def.getDataSize());
        read[1] = -1;
        byte[] write = new byte[11];
        this.def.writeTo(write, 1);
        read[1] = 0;
        Assert.assertTrue((boolean)Arrays.equals(read, write));
    }
}

