/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.crypto;

import de.schlichtherle.truezip.crypto.SICSeekableBlockCipher;
import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class SICSeekableBlockCipherTest {
    @Test
    public void compareModes() {
        AESEngine engine = new AESEngine();
        int blockSize = engine.getBlockSize();
        SICBlockCipher ref = new SICBlockCipher((BlockCipher)engine);
        SICSeekableBlockCipher uut = new SICSeekableBlockCipher((BlockCipher)engine);
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator();
        byte[] salt = new byte[blockSize];
        new SecureRandom().nextBytes(salt);
        gen.init("secret".getBytes(), salt, 1);
        ParametersWithIV param = (ParametersWithIV)gen.generateDerivedParameters(blockSize * 8, blockSize * 8);
        ref.init(true, (CipherParameters)param);
        uut.init(true, (CipherParameters)param);
        this.assertModes((BlockCipher)ref, (BlockCipher)uut);
        ref.init(false, (CipherParameters)param);
        uut.init(false, (CipherParameters)param);
        this.assertModes((BlockCipher)ref, (BlockCipher)uut);
    }

    private void assertModes(BlockCipher ref, BlockCipher uut) {
        int blockSize = ref.getBlockSize();
        Assert.assertThat((Object)uut.getBlockSize(), (Matcher)CoreMatchers.is((Object)blockSize));
        byte[] input = new byte[blockSize];
        new Random().nextBytes(input);
        for (int i = 0; i < 2; ++i) {
            byte[] refOutput = new byte[blockSize];
            ref.processBlock(input, 0, refOutput, 0);
            byte[] uutOutput = new byte[blockSize];
            uut.processBlock(input, 0, uutOutput, 0);
            Assert.assertThat((Object)uutOutput, (Matcher)CoreMatchers.equalTo((Object)refOutput));
        }
    }
}

