/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.nio.file.zip;

import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.zip.TestWinZipAesDriver;
import de.schlichtherle.truezip.key.MockView;
import de.schlichtherle.truezip.nio.file.TPath;
import de.schlichtherle.truezip.nio.file.TPathITSuite;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.Assert;
import org.junit.Test;

public final class WinZipAesPathIT
extends TPathITSuite<TestWinZipAesDriver> {
    protected String getSuffixList() {
        return "zip";
    }

    protected TestWinZipAesDriver newArchiveDriver() {
        return new TestWinZipAesDriver();
    }

    public void setUp() throws IOException {
        super.setUp();
        TConfig config = TConfig.get();
        config.setOutputPreferences(config.getOutputPreferences().set((Enum)FsOutputOption.ENCRYPT));
    }

    private void setAction(MockView.Action action) {
        ((TestWinZipAesDriver)this.getArchiveDriver()).getView().setAction(action);
    }

    @Test
    public void testCancelling() throws IOException {
        this.setAction(MockView.Action.CANCEL);
        TPath archive = this.getArchive();
        Assert.assertFalse((boolean)Files.exists((Path)archive.toNonArchivePath(), new LinkOption[0]));
        TPath entry1 = archive.resolve("entry1");
        Files.createDirectories((Path)entry1, new FileAttribute[0]);
        Files.delete((Path)entry1);
        Files.createFile((Path)entry1, new FileAttribute[0]);
        Files.delete((Path)entry1);
        TPath entry2 = archive.resolve("entry2");
        Files.createDirectories((Path)entry2, new FileAttribute[0]);
        Files.delete((Path)entry2);
        Files.createFile((Path)entry2, new FileAttribute[0]);
        Files.delete((Path)entry2);
    }

    @Test
    public void testFileStatus() throws IOException {
        TPath archive = this.getArchive();
        TPath inner = archive.resolve("inner" + this.getSuffix());
        Files.createDirectory((Path)archive, new FileAttribute[0]);
        Files.createDirectory((Path)inner, new FileAttribute[0]);
        this.umount();
        this.setAction(MockView.Action.CANCEL);
        Assert.assertTrue((boolean)Files.exists((Path)archive, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isDirectory((Path)archive, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)archive, new LinkOption[0]));
        this.umount();
        this.setAction(MockView.Action.ENTER);
        Assert.assertTrue((boolean)Files.exists((Path)archive, new LinkOption[0]));
        Assert.assertTrue((boolean)Files.isDirectory((Path)archive, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)archive, new LinkOption[0]));
        this.setAction(MockView.Action.CANCEL);
        Assert.assertTrue((boolean)Files.exists((Path)inner, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isDirectory((Path)inner, new LinkOption[0]));
        Assert.assertFalse((boolean)Files.isRegularFile((Path)inner, new LinkOption[0]));
        this.umount();
        try {
            archive.toFile().rm_r();
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.umount();
        this.setAction(MockView.Action.ENTER);
        archive.toFile().rm_r();
    }
}

