/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.inst.jmx.JmxEntryViewMXBean;
import de.schlichtherle.truezip.socket.IOPool;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.management.ManagementFactory;
import java.util.Date;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

@DefaultAnnotation(value={NonNull.class})
final class JmxEntryView
extends StandardMBean
implements JmxEntryViewMXBean {
    private static final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private final IOPool.Entry<?> model;

    static JmxEntryViewMXBean register(IOPool.Entry<?> model) {
        ObjectName name = JmxEntryView.getObjectName(model);
        JmxEntryView view = new JmxEntryView(model);
        try {
            try {
                mbs.registerMBean(view, name);
                return view;
            }
            catch (InstanceAlreadyExistsException ignored) {
                return JMX.newMXBeanProxy(mbs, name, JmxEntryViewMXBean.class);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static void unregister(IOPool.Entry<?> model) {
        ObjectName name = JmxEntryView.getObjectName(model);
        try {
            try {
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException ignored) {}
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static ObjectName getObjectName(IOPool.Entry<?> model) {
        String path = model.getName();
        try {
            return new ObjectName(IOPool.Entry.class.getName(), "name", ObjectName.quote(path));
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private JmxEntryView(IOPool.Entry<?> model) {
        super(JmxEntryViewMXBean.class, true);
        this.model = model;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "An I/O pool entry.";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String description = null;
        if (info.getName().equals("Name")) {
            description = "The name of this I/O pool entry.";
        } else if (info.getName().equals("SizeOfData")) {
            description = "The data size of this I/O pool entry.";
        } else if (info.getName().equals("SizeOfStorage")) {
            description = "The storage size of this I/O pool entry.";
        } else if (info.getName().equals("TimeWritten")) {
            description = "The last write time of this I/O pool entry.";
        } else if (info.getName().equals("TimeRead")) {
            description = "The last read or access time of this I/O pool entry.";
        } else if (info.getName().equals("TimeCreated")) {
            description = "The creation time of this I/O pool entry.";
        }
        return description;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String description = null;
        return description;
    }

    @Override
    public String getName() {
        return this.model.getName();
    }

    @Override
    public long getSizeOfData() {
        return this.model.getSize(Entry.Size.DATA);
    }

    @Override
    public long getSizeOfStorage() {
        return this.model.getSize(Entry.Size.STORAGE);
    }

    @Override
    public String getTimeWritten() {
        long time = this.model.getTime(Entry.Access.WRITE);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public String getTimeRead() {
        long time = this.model.getTime(Entry.Access.READ);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public String getTimeCreated() {
        long time = this.model.getTime(Entry.Access.CREATE);
        return -1L == time ? null : new Date(time).toString();
    }
}

