/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst;

import de.schlichtherle.truezip.entry.DecoratingEntry;
import de.schlichtherle.truezip.fs.inst.InstrumentingDirector;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import net.jcip.annotations.Immutable;

@Immutable
@DefaultAnnotation(value={NonNull.class})
public class InstrumentingIOPool<E extends IOPool.Entry<E>>
implements IOPool<E> {
    protected final InstrumentingDirector director;
    protected final IOPool<E> delegate;

    public InstrumentingIOPool(IOPool<E> pool, InstrumentingDirector director) {
        if (null == pool) {
            throw new NullPointerException();
        }
        this.director = director.check();
        this.delegate = pool;
    }

    public IOPool.Entry<E> allocate() throws IOException {
        return new InstrumentingEntry((IOPool.Entry)this.delegate.allocate());
    }

    public void release(IOPool.Entry<E> resource) throws IOException {
        resource.release();
    }

    public class InstrumentingEntry
    extends DecoratingEntry<IOPool.Entry<E>>
    implements IOPool.Entry<E> {
        protected InstrumentingEntry(IOPool.Entry<E> delegate) {
            super(delegate);
        }

        public InputSocket<E> getInputSocket() {
            return InstrumentingIOPool.this.director.instrument(((IOPool.Entry)this.delegate).getInputSocket(), this);
        }

        public OutputSocket<E> getOutputSocket() {
            return InstrumentingIOPool.this.director.instrument(((IOPool.Entry)this.delegate).getOutputSocket(), this);
        }

        public void release() throws IOException {
            ((IOPool.Entry)this.delegate).release();
        }
    }
}

