/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.fs.inst.jmx.JmxIOStatistics;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
final class JmxOutputStream
extends DecoratingOutputStream {
    private final JmxIOStatistics stats;

    JmxOutputStream(OutputStream out, JmxIOStatistics stats) {
        super(out);
        assert (null != stats);
        this.stats = stats;
    }

    public void write(int b) throws IOException {
        this.delegate.write(b);
        this.stats.incBytesWritten(1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
        this.stats.incBytesWritten(len);
    }
}

