/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.fs.inst.jmx.JmxIOStatistics;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class JmxReadOnlyFile
extends DecoratingReadOnlyFile {
    private final JmxIOStatistics stats;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    JmxReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile rof, JmxIOStatistics stats) {
        super(rof);
        assert (null != stats);
        this.stats = stats;
    }

    public int read() throws IOException {
        int ret = this.delegate.read();
        if (0 < ret) {
            this.stats.incBytesRead(1);
        }
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.delegate.read(b, off, len);
        if (0 < ret) {
            this.stats.incBytesRead(ret);
        }
        return ret;
    }
}

