/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.inst.jmx.JmxDirector;
import de.schlichtherle.truezip.fs.inst.jmx.JmxManagerViewMXBean;
import de.schlichtherle.truezip.fs.inst.jmx.JmxModelView;
import de.schlichtherle.truezip.fs.inst.jmx.JmxModelViewMXBean;
import de.schlichtherle.truezip.util.BitField;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

final class JmxManagerView
extends StandardMBean
implements JmxManagerViewMXBean {
    private static final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private static final BitField<FsSyncOption> SYNC_OPTIONS = BitField.of((Enum)FsSyncOption.CLEAR_CACHE);
    private final FsManager model;

    static JmxManagerViewMXBean register(FsManager model) {
        JmxManagerView view = new JmxManagerView(model);
        ObjectName name = JmxManagerView.getObjectName(model);
        try {
            try {
                mbs.registerMBean(view, name);
                return view;
            }
            catch (InstanceAlreadyExistsException ignored) {
                return JMX.newMXBeanProxy(mbs, name, JmxManagerViewMXBean.class);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static void unregister(FsManager model) {
        ObjectName name = JmxManagerView.getObjectName(model);
        try {
            try {
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException ignored) {}
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static ObjectName getObjectName(FsManager model) {
        try {
            return new ObjectName(FsManager.class.getName(), "name", "SINGLETON");
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private JmxManagerView(FsManager model) {
        super(JmxManagerViewMXBean.class, true);
        this.model = model;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "The federated file system manager.";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String description = null;
        if (info.getName().equals("FederatedFileSystems")) {
            description = "The federated file systems managed by this instance.";
        } else if (info.getName().equals("FileSystemsTotal")) {
            description = "The total number of managed federated file systems.";
        } else if (info.getName().equals("FileSystemsTouched")) {
            description = "The number of managed federated file systems which have been touched and need unmounting.";
        } else if (info.getName().equals("TopLevelFileSystemsTotal")) {
            description = "The total number of managed top level federated file systems.";
        } else if (info.getName().equals("TopLevelFileSystemsTouched")) {
            description = "The number of managed top level federated file systems which have been touched and need unmounting.";
        }
        return description;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String description = null;
        if (info.getName().equals("clearStatistics")) {
            description = "Clears all but the last I/O statistics.";
        } else if (info.getName().equals("umount")) {
            description = "Unmounts all managed federated file systems. If any file system is busy with I/O, an FsSyncException is thrown.";
        }
        return description;
    }

    @Override
    public JmxModelViewMXBean[] getFederatedFileSystems() {
        int size = this.model.getSize();
        ArrayList<JmxModelViewMXBean> list = new ArrayList<JmxModelViewMXBean>(size);
        for (FsController controller : this.model) {
            list.add(JmxModelView.register(controller.getModel()));
        }
        return list.toArray(new JmxModelViewMXBean[size]);
    }

    @Override
    public int getFileSystemsTotal() {
        return this.model.getSize();
    }

    @Override
    public int getFileSystemsTouched() {
        int result = 0;
        for (FsController controller : this.model) {
            if (!controller.getModel().isTouched()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getTopLevelFileSystemsTotal() {
        int result = 0;
        for (FsController controller : this.model) {
            if (null != controller.getParent().getParent()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public int getTopLevelFileSystemsTouched() {
        int result = 0;
        for (FsController controller : this.model) {
            if (null != controller.getParent().getParent() || !controller.getModel().isTouched()) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void umount() throws FsSyncException {
        this.model.sync(SYNC_OPTIONS);
    }

    @Override
    public void clearStatistics() {
        JmxDirector.SINGLETON.clearStatistics();
    }
}

