/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jul;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.inst.jul.JulNio2OutputSocket;
import de.schlichtherle.truezip.fs.inst.jul.JulOutputSocket;
import de.schlichtherle.truezip.fs.inst.jul.NeverThrowable;
import de.schlichtherle.truezip.io.DecoratingSeekableByteChannel;
import de.schlichtherle.truezip.socket.IOPool;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.Immutable;

@Immutable
final class JulOutputByteChannel<E extends Entry>
extends DecoratingSeekableByteChannel {
    private static final Logger logger = Logger.getLogger(JulOutputByteChannel.class.getName());
    private final JulOutputSocket<E> socket;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    JulOutputByteChannel(@WillCloseWhenClosed SeekableByteChannel model, JulNio2OutputSocket<E> socket) throws IOException {
        super(model);
        if (null == model) {
            throw new NullPointerException();
        }
        this.socket = socket;
        Entry target = socket.getLocalTarget();
        Level level = target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
        logger.log(level, "Randomly writing " + target, new NeverThrowable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.delegate.close();
        }
        catch (Throwable throwable) {
            Entry target = this.socket.getLocalTarget();
            Level level = target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
            logger.log(level, "Closed " + target, new NeverThrowable());
            throw throwable;
        }
        Entry target = this.socket.getLocalTarget();
        Level level = target instanceof IOPool.Entry ? Level.FINER : Level.FINEST;
        logger.log(level, "Closed " + target, new NeverThrowable());
    }
}

