/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst;

import de.schlichtherle.truezip.entry.DecoratingEntry;
import de.schlichtherle.truezip.fs.inst.InstrumentingDirector;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import java.io.IOException;
import javax.annotation.concurrent.Immutable;

@Immutable
public class InstrumentingIOPool<E extends IOPool.Entry<E>, D extends InstrumentingDirector<D>>
implements IOPool<E> {
    protected final D director;
    protected final IOPool<E> delegate;

    public InstrumentingIOPool(IOPool<E> pool, D director) {
        if (null == pool || null == director) {
            throw new NullPointerException();
        }
        this.director = director;
        this.delegate = pool;
    }

    public IOPool.Entry<E> allocate() throws IOException {
        return new Buffer((IOPool.Entry)this.delegate.allocate());
    }

    public void release(IOPool.Entry<E> resource) throws IOException {
        resource.release();
    }

    public String toString() {
        return String.format("%s[delegate=%s]", this.getClass().getName(), this.delegate);
    }

    public class Buffer
    extends DecoratingEntry<IOPool.Entry<E>>
    implements IOPool.Entry<E> {
        protected Buffer(IOPool.Entry<E> delegate) {
            super(delegate);
        }

        public InputSocket<E> getInputSocket() {
            return ((InstrumentingDirector)InstrumentingIOPool.this.director).instrument(((IOPool.Entry)this.delegate).getInputSocket(), this);
        }

        public OutputSocket<E> getOutputSocket() {
            return ((InstrumentingDirector)InstrumentingIOPool.this.director).instrument(((IOPool.Entry)this.delegate).getOutputSocket(), this);
        }

        public void release() throws IOException {
            ((IOPool.Entry)this.delegate).release();
        }
    }
}

