/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.inst.jmx.JmxIOBufferViewMXBean;
import de.schlichtherle.truezip.socket.IOPool;
import java.lang.management.ManagementFactory;
import java.util.Date;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

final class JmxIOBufferView
extends StandardMBean
implements JmxIOBufferViewMXBean {
    private static final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private final IOPool.Entry<?> buffer;

    static JmxIOBufferViewMXBean register(IOPool.Entry<?> model) {
        ObjectName name = JmxIOBufferView.getObjectName(model);
        JmxIOBufferView view = new JmxIOBufferView(model);
        try {
            try {
                mbs.registerMBean(view, name);
                return view;
            }
            catch (InstanceAlreadyExistsException ignored) {
                return JMX.newMXBeanProxy(mbs, name, JmxIOBufferViewMXBean.class);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static void unregister(IOPool.Entry<?> model) {
        ObjectName name = JmxIOBufferView.getObjectName(model);
        try {
            try {
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {}
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static ObjectName getObjectName(IOPool.Entry<?> model) {
        String path = model.getName();
        try {
            return new ObjectName(IOPool.Entry.class.getName(), "name", ObjectName.quote(path));
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private JmxIOBufferView(IOPool.Entry<?> buffer) {
        super(JmxIOBufferViewMXBean.class, true);
        this.buffer = buffer;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "An I/O pool entry.";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String description = null;
        if (info.getName().equals("Name")) {
            description = "The name of this I/O pool entry.";
        } else if (info.getName().equals("SizeOfData")) {
            description = "The data size of this I/O pool entry.";
        } else if (info.getName().equals("SizeOfStorage")) {
            description = "The storage size of this I/O pool entry.";
        } else if (info.getName().equals("TimeWritten")) {
            description = "The last write time of this I/O pool entry.";
        } else if (info.getName().equals("TimeRead")) {
            description = "The last read or access time of this I/O pool entry.";
        } else if (info.getName().equals("TimeCreated")) {
            description = "The creation time of this I/O pool entry.";
        }
        return description;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String description = null;
        return description;
    }

    @Override
    public String getName() {
        return this.buffer.getName();
    }

    @Override
    public long getSizeOfData() {
        return this.buffer.getSize(Entry.Size.DATA);
    }

    @Override
    public long getSizeOfStorage() {
        return this.buffer.getSize(Entry.Size.STORAGE);
    }

    @Override
    public String getTimeWritten() {
        long time = this.buffer.getTime(Entry.Access.WRITE);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public String getTimeRead() {
        long time = this.buffer.getTime(Entry.Access.READ);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public String getTimeCreated() {
        long time = this.buffer.getTime(Entry.Access.CREATE);
        return -1L == time ? null : new Date(time).toString();
    }
}

