/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.inst.jmx.JmxIOStatistics;
import de.schlichtherle.truezip.fs.inst.jmx.JmxIOStatisticsMXBean;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.annotation.concurrent.ThreadSafe;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

@ThreadSafe
public class JmxIOStatisticsView
extends StandardMBean
implements JmxIOStatisticsMXBean {
    private static final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private final JmxIOStatistics stats;
    private final String type;

    static synchronized JmxIOStatisticsMXBean register(JmxIOStatistics model, String type) {
        JmxIOStatisticsView view = new JmxIOStatisticsView(model, type);
        ObjectName name = JmxIOStatisticsView.getObjectName(model, type);
        try {
            try {
                mbs.registerMBean(view, name);
                return view;
            }
            catch (InstanceAlreadyExistsException ignored) {
                return JMX.newMXBeanProxy(mbs, name, JmxIOStatisticsMXBean.class);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static void unregister(JmxIOStatistics model, String type) {
        ObjectName name = JmxIOStatisticsView.getObjectName(model, type);
        try {
            try {
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {}
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static synchronized ObjectName getObjectName(JmxIOStatistics model, String type) {
        if (null == type) {
            throw new NullPointerException();
        }
        long time = model.getTimeCreatedMillis();
        Hashtable<String, String> table = new Hashtable<String, String>(3);
        table.put("type", type);
        table.put("name", ObjectName.quote(JmxIOStatisticsView.format(time)));
        try {
            return new ObjectName(FsManager.class.getName(), table);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private JmxIOStatisticsView(JmxIOStatistics stats, String type) {
        super(JmxIOStatisticsMXBean.class, true);
        assert (null != stats);
        assert (null != type);
        this.stats = stats;
        this.type = type;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "A record of I/O statistics.";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String description = null;
        if (info.getName().equals("Type")) {
            description = "The type of these I/O statistics.";
        } else if (info.getName().equals("TimeCreated")) {
            description = "The time these I/O statistics have been created.";
        } else if (info.getName().equals("Read")) {
            description = "The number of bytes read.";
        } else if (info.getName().equals("Written")) {
            description = "The number of bytes written.";
        }
        return description;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String description = null;
        if (info.getName().equals("close")) {
            description = "Closes these I/O statistics log.";
        }
        return description;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTimeCreated() {
        return JmxIOStatisticsView.format(this.stats.getTimeCreatedMillis());
    }

    private static String format(long time) {
        return DateFormat.getDateTimeInstance().format(new Date(time));
    }

    @Override
    public long getTimeCreatedMillis() {
        return this.stats.getTimeCreatedMillis();
    }

    @Override
    public long getBytesRead() {
        return this.stats.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.stats.getBytesWritten();
    }

    @Override
    public void close() {
        JmxIOStatisticsView.unregister(this.stats, this.type);
    }
}

