/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsFilteringManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsSimpleCompositeDriver;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.fs.inst.jmx.JmxModelViewMXBean;
import de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import de.schlichtherle.truezip.fs.sl.FsManagerLocator;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

final class JmxModelView
extends StandardMBean
implements JmxModelViewMXBean {
    private static final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private static final FsCompositeDriver DRIVER = new FsSimpleCompositeDriver((FsDriverProvider)FsDriverLocator.SINGLETON);
    private final FsModel model;

    static JmxModelViewMXBean register(FsModel model) {
        ObjectName name = JmxModelView.getObjectName(model);
        JmxModelView view = new JmxModelView(model);
        try {
            try {
                mbs.registerMBean(view, name);
                return view;
            }
            catch (InstanceAlreadyExistsException ignored) {
                return JMX.newMXBeanProxy(mbs, name, JmxModelViewMXBean.class);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static void unregister(FsModel model) {
        ObjectName name = JmxModelView.getObjectName(model);
        try {
            try {
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {}
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static ObjectName getObjectName(FsModel model) {
        String path = model.getMountPoint().toHierarchicalUri().toString();
        try {
            return new ObjectName(FsModel.class.getName(), "path", ObjectName.quote(path));
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private JmxModelView(FsModel model) {
        super(JmxModelViewMXBean.class, true);
        this.model = model;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "A file system model.";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String name = info.getName();
        String description = null;
        if (name.equals("MountPoint")) {
            description = "The mount point URI of this file system.";
        } else if (name.equals("Mounted")) {
            description = "Whether or not this file system needs to get sync()ed.";
        } else if (name.equals("ParentMountPoint")) {
            description = "The mount point URI of the parent file system.";
        } else if (name.equals("SizeOfData")) {
            description = "The data size of this file system.";
        } else if (name.equals("SizeOfStorage")) {
            description = "The storage size of this file system.";
        } else if (name.equals("TimeWritten")) {
            description = "The last write time of this file system.";
        } else if (name.equals("TimeRead")) {
            description = "The last read or access time of this file system.";
        } else if (name.equals("TimeCreated")) {
            description = "The creation time of this file system.";
        }
        return description;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String description = null;
        if (info.getName().equals("sync")) {
            description = "Synchronizes this file system and all enclosed file systems. If any file system is busy with I/O, an FsSyncException is thrown.";
        }
        return description;
    }

    @Override
    public boolean isMounted() {
        return this.model.isMounted();
    }

    @Override
    public String getMountPoint() {
        return this.model.getMountPoint().toString();
    }

    @Override
    public String getParentMountPoint() {
        FsModel parent = this.model.getParent();
        return null != parent ? parent.getMountPoint().toString() : null;
    }

    @Override
    public long getSizeOfData() {
        return this.sizeOf(Entry.Size.DATA);
    }

    @Override
    public long getSizeOfStorage() {
        return this.sizeOf(Entry.Size.STORAGE);
    }

    private long sizeOf(Entry.Size type) {
        FsEntry entry = this.getEntry();
        return null == entry ? -1L : entry.getSize(type);
    }

    @Override
    public String getTimeWritten() {
        FsEntry entry = this.getEntry();
        long time = null == entry ? -1L : entry.getTime(Entry.Access.WRITE);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public String getTimeRead() {
        FsEntry entry = this.getEntry();
        long time = null == entry ? -1L : entry.getTime(Entry.Access.READ);
        return -1L == time ? null : new Date(time).toString();
    }

    @Override
    public String getTimeCreated() {
        FsEntry entry = this.getEntry();
        long time = null == entry ? -1L : entry.getTime(Entry.Access.CREATE);
        return -1L == time ? null : new Date(time).toString();
    }

    @CheckForNull
    private FsEntry getEntry() {
        FsMountPoint mp = this.model.getMountPoint();
        FsMountPoint pmp = mp.getParent();
        try {
            FsManager m = FsManagerLocator.SINGLETON.get();
            return null == pmp ? m.getController(mp, DRIVER).getEntry(FsEntryName.ROOT) : m.getController(pmp, DRIVER).getEntry(mp.getPath().getEntryName());
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public void sync() throws FsSyncException {
        new FsFilteringManager(FsManagerLocator.SINGLETON.get(), this.model.getMountPoint()).sync(FsSyncOptions.NONE);
    }
}

