/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.fs.inst.jmx.JmxIOStatistics;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class JmxOutputStream
extends DecoratingOutputStream {
    private final JmxIOStatistics stats;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    JmxOutputStream(@WillCloseWhenClosed OutputStream out, JmxIOStatistics stats) {
        super(out);
        assert (null != stats);
        this.stats = stats;
    }

    public void write(int b) throws IOException {
        this.delegate.write(b);
        this.stats.incBytesWritten(1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.delegate.write(b, off, len);
        this.stats.incBytesWritten(len);
    }
}

