/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.inst.jmx;

import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.fs.inst.jmx.JmxDirector;
import de.schlichtherle.truezip.fs.inst.jmx.JmxManagerViewMXBean;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.StandardMBean;

final class JmxManagerView
extends StandardMBean
implements JmxManagerViewMXBean {
    private static final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    private final FsManager manager;

    static JmxManagerViewMXBean register(FsManager model) {
        JmxManagerView view = new JmxManagerView(model);
        ObjectName name = JmxManagerView.getObjectName(model);
        try {
            try {
                mbs.registerMBean(view, name);
                return view;
            }
            catch (InstanceAlreadyExistsException ignored) {
                return JMX.newMXBeanProxy(mbs, name, JmxManagerViewMXBean.class);
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static void unregister(FsManager model) {
        ObjectName name = JmxManagerView.getObjectName(model);
        try {
            try {
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException ignored) {}
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static ObjectName getObjectName(FsManager model) {
        Class<?> clazz = model.getClass();
        try {
            return new ObjectName(clazz.getPackage().getName(), "type", clazz.getSimpleName());
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    private JmxManagerView(FsManager manager) {
        super(JmxManagerViewMXBean.class, true);
        this.manager = manager;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        MBeanInfo mbinfo = super.getMBeanInfo();
        return new MBeanInfo(mbinfo.getClassName(), mbinfo.getDescription(), mbinfo.getAttributes(), mbinfo.getConstructors(), mbinfo.getOperations(), this.getNotificationInfo());
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        return "A JMX file system manager.";
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String name = info.getName();
        String description = null;
        if (name.equals("FileSystemsTotal")) {
            description = "The total number of file systems.";
        } else if (name.equals("FileSystemsMounted")) {
            description = "The number of file systems which have been mounted and need sync()ing.";
        } else if (name.equals("TopLevelArchiveFileSystemsTotal")) {
            description = "The total number of top level archive file systems.";
        } else if (name.equals("TopLevelArchiveFileSystemsMounted")) {
            description = "The number of top level archive file systems which have been mounted and need sync()ing.";
        }
        return description;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int sequence) {
        return null;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String name = info.getName();
        if (name.equals("sync")) {
            return "Synchronizes all managed file systems. If any file system is busy with I/O, an FsSyncException is thrown.";
        }
        if (name.equals("clearStatistics")) {
            return "Clears all but the last I/O statistics.";
        }
        return null;
    }

    @Override
    public int getFileSystemsTotal() {
        return this.manager.getSize();
    }

    @Override
    public int getFileSystemsMounted() {
        int mounted = 0;
        for (FsController controller : this.manager) {
            if (!controller.getModel().isMounted()) continue;
            ++mounted;
        }
        return mounted;
    }

    @Override
    public int getTopLevelArchiveFileSystemsTotal() {
        int total = 0;
        for (FsController controller : this.manager) {
            if (!this.isTopLevelArchive(controller)) continue;
            ++total;
        }
        return total;
    }

    @Override
    public int getTopLevelArchiveFileSystemsMounted() {
        int mounted = 0;
        for (FsController controller : this.manager) {
            if (!this.isTopLevelArchive(controller) || !controller.getModel().isMounted()) continue;
            ++mounted;
        }
        return mounted;
    }

    private boolean isTopLevelArchive(FsController<?> controller) {
        FsController parent = controller.getParent();
        return null != parent && null == parent.getParent();
    }

    @Override
    public void sync() throws FsSyncException {
        this.manager.sync(FsSyncOptions.NONE);
    }

    @Override
    public void clearStatistics() {
        JmxDirector.SINGLETON.clearStatistics();
    }
}

