/*
 * Copyright (C) 2006-2011 Schlichtherle IT Services
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsException;
import de.schlichtherle.truezip.fs.FsModel;
import java.io.FileNotFoundException;

/**
 * Indicates that a file system is temporarily not accessible,
 * e.g. if a key for decryption is currently not available.
 *
 * @author Christian Schlichtherle
 * @version $Id$
 */
public final class FsTabuException extends FsException {

    private static final long serialVersionUID = 7623046187612846354L;

    /**
     * Constructs a tabu file exception.
     *
     * @param cause The nullable temporary cause of this exception.
     */
    public FsTabuException(FsModel model, Throwable cause) {
        super(model, cause);
    }
}
